/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class TypeUtils {
    private static final Map<Class<?>, Class<?>> primitiveToBoxed;
    private static final Map<Class<?>, Class<?>> boxedToPrimitive;
    public static final Set<Class<?>> PRIMITIVE_TYPES;
    public static final Set<Class<?>> BOXED_TYPES;
    public static final Map<String, Class<?>> primitiveClassNameToClass;

    public static Class<?> getBoxedType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        return primitiveToBoxed.get(type);
    }

    public static Class<?> getUnboxedType(Class<?> type) {
        if (type.isPrimitive()) {
            return type;
        }
        return boxedToPrimitive.get(type);
    }

    public static Class<?> getUnboxedTypeIfBoxed(@NotNull Class<?> type) {
        Class<?> unboxedType = TypeUtils.getUnboxedType(type);
        return unboxedType != null ? unboxedType : type;
    }

    public static byte[] toByteArray(float[] array) {
        byte[] result = new byte[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)array[i];
        }
        return result;
    }

    public static byte[] toByteArray(int[] array) {
        byte[] result = new byte[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)array[i];
        }
        return result;
    }

    public static byte[] toByteArray(short[] array) {
        byte[] result = new byte[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)array[i];
        }
        return result;
    }

    public static byte[] toByteArray(long[] array) {
        byte[] result = new byte[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)array[i];
        }
        return result;
    }

    public static byte[] toByteArray(double[] array) {
        byte[] result = new byte[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)array[i];
        }
        return result;
    }

    public static float[] toFloatArray(byte[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static float[] toFloatArray(int[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static float[] toFloatArray(short[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static float[] toFloatArray(long[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static float[] toFloatArray(double[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (float)array[i];
        }
        return result;
    }

    public static short[] toShortArray(float[] array) {
        short[] result = new short[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (short)array[i];
        }
        return result;
    }

    public static short[] toShortArray(int[] array) {
        short[] result = new short[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (short)array[i];
        }
        return result;
    }

    public static short[] toShortArray(byte[] array) {
        short[] result = new short[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static short[] toShortArray(long[] array) {
        short[] result = new short[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (short)array[i];
        }
        return result;
    }

    public static short[] toShortArray(double[] array) {
        short[] result = new short[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (short)array[i];
        }
        return result;
    }

    public static long[] toLongArray(float[] array) {
        long[] result = new long[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (long)array[i];
        }
        return result;
    }

    public static long[] toLongArray(int[] array) {
        long[] result = new long[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static long[] toLongArray(short[] array) {
        long[] result = new long[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static long[] toLongArray(byte[] array) {
        long[] result = new long[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static long[] toLongArray(double[] array) {
        long[] result = new long[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (long)array[i];
        }
        return result;
    }

    public static int[] toIntArray(float[] array) {
        int[] result = new int[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (int)array[i];
        }
        return result;
    }

    public static int[] toIntArray(byte[] array) {
        int[] result = new int[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static int[] toIntArray(short[] array) {
        int[] result = new int[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static int[] toIntArray(long[] array) {
        int[] result = new int[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (int)array[i];
        }
        return result;
    }

    public static int[] toIntArray(double[] array) {
        int[] result = new int[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (int)array[i];
        }
        return result;
    }

    public static double[] toDoubleArray(float[] array) {
        double[] result = new double[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static double[] toDoubleArray(int[] array) {
        double[] result = new double[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static double[] toDoubleArray(short[] array) {
        double[] result = new double[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static double[] toDoubleArray(long[] array) {
        double[] result = new double[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static double[] toDoubleArray(double[] array) {
        double[] result = new double[array.length];
        System.arraycopy(array, 0, result, 0, result.length);
        return result;
    }

    public static boolean isConvertibleToPrimitive(Class<?> type) {
        Class<?> unboxedType = TypeUtils.getUnboxedType(type);
        return unboxedType != null && unboxedType != Boolean.TYPE;
    }

    public static boolean isBoxedType(Class<?> exprType) {
        return BOXED_TYPES.contains(exprType);
    }

    public static String nullConstantForType(Class<?> type) {
        if (type == Character.TYPE) {
            return "QueryConstants.NULL_CHAR";
        }
        if (type == Byte.TYPE) {
            return "QueryConstants.NULL_BYTE";
        }
        if (type == Short.TYPE) {
            return "QueryConstants.NULL_SHORT";
        }
        if (type == Integer.TYPE) {
            return "QueryConstants.NULL_INT";
        }
        if (type == Long.TYPE) {
            return "QueryConstants.NULL_LONG";
        }
        if (type == Boolean.class) {
            return "QueryConstants.NULL_BOOLEAN";
        }
        if (type == Double.TYPE) {
            return "QueryConstants.NULL_DOUBLE";
        }
        if (type == Float.TYPE) {
            return "QueryConstants.NULL_FLOAT";
        }
        return "null";
    }

    public static boolean isPrimitiveNumeric(@NotNull Class<?> c) {
        return c.equals(Double.TYPE) || c.equals(Float.TYPE) || c.equals(Integer.TYPE) || c.equals(Long.TYPE) || c.equals(Short.TYPE) || c.equals(Byte.TYPE);
    }

    public static boolean isBoxedNumeric(@NotNull Class<?> c) {
        return Number.class.isAssignableFrom(c);
    }

    public static boolean isPrimitiveChar(@NotNull Class<?> c) {
        return c.equals(Character.TYPE);
    }

    public static boolean isBoxedChar(@NotNull Class<?> c) {
        return Character.class.isAssignableFrom(c);
    }

    public static boolean isBoxedInteger(@NotNull Class<?> c) {
        return Integer.class.isAssignableFrom(c);
    }

    public static boolean isBoxedLong(@NotNull Class<?> c) {
        return Long.class.isAssignableFrom(c);
    }

    public static boolean isBoxedShort(@NotNull Class<?> c) {
        return Short.class.isAssignableFrom(c);
    }

    public static boolean isBoxedFloat(@NotNull Class<?> c) {
        return Float.class.isAssignableFrom(c);
    }

    public static boolean isBoxedDouble(@NotNull Class<?> c) {
        return Double.class.isAssignableFrom(c);
    }

    public static boolean isBoxedByte(@NotNull Class<?> c) {
        return Byte.class.isAssignableFrom(c);
    }

    public static boolean isBoxedArithmetic(@NotNull Class<?> c) {
        return TypeUtils.isBoxedLong(c) || TypeUtils.isBoxedInteger(c) || TypeUtils.isBoxedShort(c) || TypeUtils.isBoxedByte(c);
    }

    public static boolean isBoxedBoolean(@NotNull Class<?> c) {
        return Boolean.class.isAssignableFrom(c);
    }

    public static boolean isNumeric(@NotNull Class<?> c) {
        return TypeUtils.isPrimitiveNumeric(c) || TypeUtils.isBoxedNumeric(c);
    }

    public static boolean isCharacter(@NotNull Class<?> c) {
        return TypeUtils.isPrimitiveChar(c) || TypeUtils.isBoxedChar(c);
    }

    public static boolean isDateTime(Class<?> type) {
        return Instant.class.isAssignableFrom(type) || ZonedDateTime.class.isAssignableFrom(type) || type.getAnnotation(IsDateTime.class) != null && type.getAnnotation(IsDateTime.class).value();
    }

    public static boolean isString(Class<?> type) {
        return String.class.isAssignableFrom(type);
    }

    public static boolean isBigNumeric(Class<?> type) {
        return BigInteger.class.isAssignableFrom(type) || BigDecimal.class.isAssignableFrom(type);
    }

    public static boolean isFloatType(Class<?> type) {
        return type.equals(Double.TYPE) || type.equals(Float.TYPE) || TypeUtils.isBoxedDouble(type) || TypeUtils.isBoxedFloat(type);
    }

    public static String objectToString(Object o) throws IOException {
        if (o == null) {
            return null;
        }
        Class<?> type = o.getClass();
        if (type == String.class || TypeUtils.isConvertibleToPrimitive(type) || TypeUtils.isNumeric(type)) {
            return o.toString();
        }
        if (o instanceof Serializable) {
            return TypeUtils.encode64Serializable((Serializable)o);
        }
        throw new RuntimeException("Failed to convert object of type " + type.getCanonicalName() + ".  Type not supported");
    }

    public static Optional<Object> fromString(String string, String typeString) throws IOException {
        try {
            Class<?> type = Class.forName(typeString);
            return Optional.ofNullable(TypeUtils.fromString(string, type));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public static Object fromString(String string, Class<?> type) throws IOException {
        Class<?> boxedType = TypeUtils.getBoxedType(type);
        try {
            if (boxedType == String.class) {
                return string;
            }
            if (boxedType == Boolean.class) {
                return Boolean.parseBoolean(string);
            }
            if (boxedType == Integer.class) {
                return Integer.parseInt(string);
            }
            if (boxedType == Double.class) {
                return Double.parseDouble(string);
            }
            if (boxedType == Short.class) {
                return Short.parseShort(string);
            }
            if (boxedType == Long.class) {
                return Long.parseLong(string);
            }
            if (boxedType == Float.class) {
                return Float.valueOf(Float.parseFloat(string));
            }
            if (boxedType == BigInteger.class) {
                return new BigInteger(string);
            }
            if (boxedType == BigDecimal.class) {
                return new BigDecimal(string);
            }
            if (boxedType == Byte.class) {
                return Byte.parseByte(string);
            }
            if (boxedType == Character.class) {
                return Character.valueOf(string.charAt(0));
            }
            if (Serializable.class.isAssignableFrom(boxedType)) {
                return TypeUtils.decode64Serializable(string);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse " + string + "into type " + type.getCanonicalName(), e);
        }
        throw new RuntimeException("Failed to parse " + string + "into type " + type.getCanonicalName() + ".  Type not supported");
    }

    public static String encode64Serializable(Serializable serializable) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String string;
            try (ObjectOutputStream os = new ObjectOutputStream(bos);){
                os.writeObject(serializable);
                string = Base64.getEncoder().encodeToString(bos.toByteArray());
            }
            return string;
        }
    }

    public static Object decode64Serializable(String string) throws IOException, ClassNotFoundException {
        try (ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(string)));){
            Object object = is.readObject();
            return object;
        }
    }

    public static Class<?> getErasedType(Type paramType) {
        if (paramType instanceof Class) {
            return (Class)paramType;
        }
        if (paramType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)paramType).getRawType();
        }
        if (paramType instanceof WildcardType) {
            Type[] upper = ((WildcardType)paramType).getUpperBounds();
            return TypeUtils.getErasedType(upper[0]);
        }
        if (paramType instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)paramType).getBounds();
            if (bounds.length > 1) {
                Class[] erasedBounds = new Class[bounds.length];
                Class<?> weakest = null;
                for (int i = 0; i < erasedBounds.length; ++i) {
                    erasedBounds[i] = TypeUtils.getErasedType(bounds[i]);
                    weakest = i == 0 ? erasedBounds[i] : TypeUtils.getWeakest(weakest, erasedBounds[i]);
                    if (weakest == Object.class) break;
                }
                return weakest;
            }
            return TypeUtils.getErasedType(bounds[0]);
        }
        throw new UnsupportedOperationException();
    }

    private static Class<?> getWeakest(Class<?> one, Class<?> two) {
        if (one.isAssignableFrom(two)) {
            return one;
        }
        if (two.isAssignableFrom(one)) {
            return two;
        }
        Set<Class<Class<?>>> oneInterfaces = TypeUtils.getFlattenedInterfaces(one);
        Set<Class<?>> twoInterfaces = TypeUtils.getFlattenedInterfaces(two);
        oneInterfaces.retainAll(twoInterfaces);
        Class strongest = Object.class;
        for (Class<Object> clazz : oneInterfaces) {
            if (strongest.isAssignableFrom(clazz)) {
                strongest = clazz;
                continue;
            }
            if (clazz.isAssignableFrom(strongest)) continue;
            return Object.class;
        }
        return strongest;
    }

    private static Set<Class<?>> getFlattenedInterfaces(Class<?> cls) {
        HashSet set = new HashSet();
        while (cls != null && cls != Object.class) {
            for (Class<?> iface : cls.getInterfaces()) {
                TypeUtils.collectInterfaces(set, iface);
            }
            cls = cls.getSuperclass();
        }
        return set;
    }

    private static void collectInterfaces(Collection<Class<?>> into, Class<?> cls) {
        if (into.add(cls)) {
            for (Class<?> iface : cls.getInterfaces()) {
                if (!into.add(iface)) continue;
                TypeUtils.collectInterfaces(into, iface);
            }
        }
    }

    public static Class<?> classForName(String className) throws ClassNotFoundException {
        Class<?> result = primitiveClassNameToClass.get(className);
        if (result == null) {
            return Class.forName(className);
        }
        return result;
    }

    public static <T> TypeBoxer<T> getTypeBoxer(Class<T> type) {
        if (type == Byte.TYPE || type == Byte.class) {
            return new TypeBoxer<Byte>(){

                @Override
                public Byte get(Byte result) {
                    return result == -128 ? null : result;
                }
            };
        }
        if (type == Character.TYPE || type == Character.class) {
            return new TypeBoxer<Character>(){

                @Override
                public Character get(Character result) {
                    return result.charValue() == '\uffff' ? null : result;
                }
            };
        }
        if (type == Double.TYPE || type == Double.class) {
            return new TypeBoxer<Double>(){

                @Override
                public Double get(Double result) {
                    return result == -1.7976931348623157E308 ? null : result;
                }
            };
        }
        if (type == Float.TYPE || type == Float.class) {
            return new TypeBoxer<Float>(){

                @Override
                public Float get(Float result) {
                    return result.floatValue() == -3.4028235E38f ? null : result;
                }
            };
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return new TypeBoxer<Integer>(){

                @Override
                public Integer get(Integer result) {
                    return result == Integer.MIN_VALUE ? null : result;
                }
            };
        }
        if (type == Long.TYPE || type == Long.class) {
            return new TypeBoxer<Long>(){

                @Override
                public Long get(Long result) {
                    return result == Long.MIN_VALUE ? null : result;
                }
            };
        }
        if (type == Short.TYPE || type == Short.class) {
            return new TypeBoxer<Short>(){

                @Override
                public Short get(Short result) {
                    return result == Short.MIN_VALUE ? null : result;
                }
            };
        }
        return new TypeBoxer<Object>(){

            @Override
            public Object get(Object result) {
                return result;
            }
        };
    }

    public static Boolean box(Boolean value) {
        return value;
    }

    public static Byte box(byte value) {
        return value == -128 ? null : Byte.valueOf(value);
    }

    public static Character box(char value) {
        return value == '\uffff' ? null : Character.valueOf(value);
    }

    public static Double box(double value) {
        return value == -1.7976931348623157E308 ? null : Double.valueOf(value);
    }

    public static Float box(float value) {
        return value == -3.4028235E38f ? null : Float.valueOf(value);
    }

    public static Integer box(int value) {
        return value == Integer.MIN_VALUE ? null : Integer.valueOf(value);
    }

    public static Long box(long value) {
        return value == Long.MIN_VALUE ? null : Long.valueOf(value);
    }

    public static Short box(short value) {
        return value == Short.MIN_VALUE ? null : Short.valueOf(value);
    }

    public static boolean unbox(Boolean value) {
        return value;
    }

    public static byte unbox(Byte value) {
        return value == null ? (byte)-128 : (byte)value;
    }

    public static char unbox(Character value) {
        return value == null ? (char)'\uffff' : (char)value.charValue();
    }

    public static double unbox(Double value) {
        return value == null ? -1.7976931348623157E308 : value;
    }

    public static float unbox(Float value) {
        return value == null ? -3.4028235E38f : value.floatValue();
    }

    public static int unbox(Integer value) {
        return value == null ? Integer.MIN_VALUE : value;
    }

    public static long unbox(Long value) {
        return value == null ? Long.MIN_VALUE : value;
    }

    public static short unbox(Short value) {
        return value == null ? (short)Short.MIN_VALUE : (short)value;
    }

    static {
        LinkedHashMap<Class<Serializable>, Class> primitiveToBoxedTemp = new LinkedHashMap<Class<Serializable>, Class>();
        LinkedHashMap<Class, Class> boxedToPrimitiveTemp = new LinkedHashMap<Class, Class>();
        primitiveToBoxedTemp.put(Byte.TYPE, Byte.class);
        primitiveToBoxedTemp.put(Short.TYPE, Short.class);
        primitiveToBoxedTemp.put(Character.TYPE, Character.class);
        primitiveToBoxedTemp.put(Integer.TYPE, Integer.class);
        primitiveToBoxedTemp.put(Long.TYPE, Long.class);
        primitiveToBoxedTemp.put(Float.TYPE, Float.class);
        primitiveToBoxedTemp.put(Double.TYPE, Double.class);
        primitiveToBoxedTemp.put(Boolean.TYPE, Boolean.class);
        for (Map.Entry classClassEntry : primitiveToBoxedTemp.entrySet()) {
            boxedToPrimitiveTemp.put((Class)classClassEntry.getValue(), (Class)classClassEntry.getKey());
        }
        primitiveToBoxed = Collections.unmodifiableMap(primitiveToBoxedTemp);
        boxedToPrimitive = Collections.unmodifiableMap(boxedToPrimitiveTemp);
        PRIMITIVE_TYPES = Collections.unmodifiableSet(primitiveToBoxedTemp.keySet());
        BOXED_TYPES = Collections.unmodifiableSet(new LinkedHashSet(primitiveToBoxedTemp.values()));
        primitiveClassNameToClass = Collections.unmodifiableMap(PRIMITIVE_TYPES.stream().collect(Collectors.toMap(Class::getName, type -> type)));
    }

    public static abstract class TypeBoxer<T> {
        public abstract T get(T var1);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IsDateTime {
        public boolean value() default true;
    }
}

