/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import io.deephaven.base.log.LogOutput;
import io.deephaven.io.log.LogEntry;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.log.impl.LogOutputStringImpl;
import io.deephaven.io.logger.Logger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class BridgingLogHandler
extends Handler {
    private static final boolean FLUSH_PENDING_ON_SHUTDOWN_DEFAULT = true;
    private static boolean flushPendingOnShutdown;
    private static ArrayList<PendingLogRecord> pending;
    private static volatile Logger log;
    private static final Map<Level, LogLevel> LEVEL_MAPPINGS;

    public static synchronized void setFlushPendingOnShutdown(boolean v) {
        flushPendingOnShutdown = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogger(Logger log) {
        Class<BridgingLogHandler> clazz = BridgingLogHandler.class;
        synchronized (BridgingLogHandler.class) {
            try {
                if (pending == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                for (PendingLogRecord p : pending) {
                    LogEntry entry = BridgingLogHandler.logEntry(log, p.level, p.timeMillis, p.throwable);
                    BridgingLogHandler.appendPendingLogRecord((LogOutput)entry, p);
                    entry.endl();
                }
                pending = null;
            }
            finally {
                BridgingLogHandler.log = log;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void pushRecord(LogRecord logRecord) {
        String sourceClassName = logRecord.getSourceClassName();
        String sourceMethodName = logRecord.getSourceMethodName();
        if (log == null) {
            Class<BridgingLogHandler> clazz = BridgingLogHandler.class;
            // MONITORENTER : io.deephaven.util.BridgingLogHandler.class
            if (log == null) {
                if (pending == null) {
                    pending = new ArrayList();
                    if (flushPendingOnShutdown) {
                        Runtime.getRuntime().addShutdownHook(new Thread(BridgingLogHandler::pushPendingToStdout));
                    }
                }
                pending.add(new PendingLogRecord(logRecord.getLevel(), logRecord.getMillis(), logRecord.getThrown(), sourceClassName, sourceMethodName, logRecord.getThreadID(), logRecord.getMessage()));
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
        }
        LogEntry entry = BridgingLogHandler.logEntry(log, logRecord.getLevel(), logRecord.getMillis(), logRecord.getThrown());
        BridgingLogHandler.appendMsg((LogOutput)entry, sourceClassName, sourceMethodName, logRecord.getThreadID(), logRecord.getMessage());
        entry.endl();
    }

    public static void appendPendingLogRecord(LogOutput logOutput, PendingLogRecord pendingLogRecord) {
        BridgingLogHandler.appendMsg(logOutput, pendingLogRecord.sourceClassName, pendingLogRecord.sourceMethodName, pendingLogRecord.threadId, pendingLogRecord.msg);
    }

    private static void appendMsg(LogOutput logOutput, String sourceClassName, String sourceMethodName, int threadId, String msg) {
        logOutput.append((CharSequence)"[").append((CharSequence)sourceClassName).append((CharSequence)":").append((CharSequence)sourceMethodName).append((CharSequence)":tid=").append(threadId).append((CharSequence)"] ").append((CharSequence)msg);
    }

    private static LogEntry logEntry(Logger log, Level level, long timeMillis, Throwable throwable) {
        return log.getEntry(BridgingLogHandler.mapLevel(level), 1000L * timeMillis, throwable);
    }

    private static LogLevel mapLevel(Level level) {
        LogLevel mapping = LEVEL_MAPPINGS.get(level);
        if (mapping != null) {
            return mapping;
        }
        return LogLevel.INFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pushPendingToStdout() {
        Class<BridgingLogHandler> clazz = BridgingLogHandler.class;
        synchronized (BridgingLogHandler.class) {
            ArrayList<PendingLogRecord> pending = BridgingLogHandler.pending;
            BridgingLogHandler.pending = null;
            boolean doFlush = flushPendingOnShutdown;
            // ** MonitorExit[var2] (shouldn't be in output)
            if (pending == null || !doFlush) {
                return;
            }
            LogOutputStringImpl logOutput = new LogOutputStringImpl();
            for (PendingLogRecord p : pending) {
                String timeStampStr = Instant.ofEpochMilli(p.timeMillis).toString();
                logOutput.append((CharSequence)timeStampStr).append((CharSequence)" ");
                BridgingLogHandler.appendPendingLogRecord((LogOutput)logOutput, p);
                logOutput.append((CharSequence)"\n");
            }
            System.out.println("Flushing pending log records on shutdown.");
            System.out.print(logOutput.toString());
            return;
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        BridgingLogHandler.pushRecord(record);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    static {
        String propValue = System.getProperty("BridgingLogHandler.flushPendingOnShutdown");
        flushPendingOnShutdown = propValue == null ? true : Boolean.parseBoolean(propValue);
        pending = null;
        log = null;
        LEVEL_MAPPINGS = new HashMap<Level, LogLevel>();
        LEVEL_MAPPINGS.put(Level.WARNING, LogLevel.WARN);
        LEVEL_MAPPINGS.put(Level.SEVERE, LogLevel.ERROR);
    }

    private static class PendingLogRecord {
        public final Level level;
        public final long timeMillis;
        public final Throwable throwable;
        public final String sourceClassName;
        public final String sourceMethodName;
        public final int threadId;
        public final String msg;

        public PendingLogRecord(Level level, long timeMillis, Throwable throwable, String sourceClassName, String sourceMethodName, int threadId, String msg) {
            this.level = level;
            this.throwable = throwable;
            this.timeMillis = timeMillis;
            this.sourceClassName = sourceClassName;
            this.sourceMethodName = sourceMethodName;
            this.threadId = threadId;
            this.msg = msg;
        }
    }
}

