/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import io.deephaven.base.string.EncodingInfo;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import org.apache.commons.io.ByteOrderMark;
import org.jetbrains.annotations.NotNull;

public class EncodingUtil {
    public static final ByteOrderMark[] EMPTY_BOM_ARRAY = new ByteOrderMark[0];

    @NotNull
    public static EncodingInfo getEncodingInfoForCharset(@NotNull Charset charSet) throws IllegalArgumentException {
        return EncodingUtil.getEncodingInfoForCharset(charSet.name());
    }

    public static EncodingInfo getEncodingInfoForCharset(@NotNull String charsetName) {
        return Arrays.stream(EncodingInfo.values()).filter(info -> info.getCharset().name().equals(charsetName)).findFirst().orElseThrow(() -> new IllegalArgumentException("No EncodingInfo for " + charsetName));
    }

    @NotNull
    public static ByteOrderMark[] getBOMsForEncoding(EncodingInfo encoding) {
        switch (encoding) {
            case UTF_8: {
                return new ByteOrderMark[]{ByteOrderMark.UTF_8};
            }
            case UTF_16BE: {
                return new ByteOrderMark[]{ByteOrderMark.UTF_16BE};
            }
            case UTF_16LE: {
                return new ByteOrderMark[]{ByteOrderMark.UTF_16LE};
            }
            case UTF_16: {
                return new ByteOrderMark[]{ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE};
            }
        }
        return EMPTY_BOM_ARRAY;
    }

    public static void putUtf8String(@NotNull ByteBuffer destination, @NotNull String value) {
        int initialPosition = destination.position();
        destination.position(initialPosition + 4);
        CharsetEncoder encoder = EncodingInfo.UTF_8.getEncoder().reset();
        if (!encoder.encode(CharBuffer.wrap(value), destination, true).isUnderflow() || !encoder.flush(destination).isUnderflow()) {
            throw new BufferOverflowException();
        }
        destination.putInt(initialPosition, destination.position() - initialPosition - 4);
    }

    public static String getUtf8String(@NotNull ByteBuffer source) {
        String result;
        int length = source.getInt();
        int initialLimit = source.limit();
        CharsetDecoder decoder = EncodingInfo.UTF_8.getDecoder().reset();
        if (length > source.remaining()) {
            throw new BufferUnderflowException();
        }
        source.limit(source.position() + length);
        try {
            result = decoder.decode(source).toString();
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("Unexpectedly failed to decode input bytes", e);
        }
        source.limit(initialLimit);
        return result;
    }
}

