/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import io.deephaven.util.FindExceptionCause;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String errorMessage;
    private final String fullStackTrace;
    private final String shortCauses;

    public ExceptionDetails(Throwable throwable) {
        this.errorMessage = throwable.toString();
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        this.fullStackTrace = writer.toString();
        this.shortCauses = FindExceptionCause.shortCauses(throwable, "\n");
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getFullStackTrace() {
        return this.fullStackTrace;
    }

    public String getShortCauses() {
        return this.shortCauses;
    }

    public String toString() {
        return this.errorMessage;
    }

    public static boolean testExceptionDetails(@Nullable ExceptionDetails exceptionDetails, @NotNull Predicate<ExceptionDetails> testToApply) {
        return exceptionDetails != null && testToApply.test(exceptionDetails);
    }
}

