/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import io.deephaven.util.BridgingLogHandler;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public final class GrpcLogging {
    public static void setupFromBooleanProperty(String property, boolean defaultValue, String shadowPath) {
        boolean logAll;
        boolean logAllDefault = defaultValue;
        String logAllStr = System.getProperty(property);
        boolean bl = logAll = logAllStr == null ? logAllDefault : Boolean.parseBoolean(logAllStr);
        if (!logAll) {
            return;
        }
        GrpcLogging.setAllLogging(shadowPath + ".");
    }

    private static void setAllLogging(String shadowPfx) {
        SimpleFormatter formatter = new SimpleFormatter();
        Logger grpcLogger = Logger.getLogger(shadowPfx + "io.grpc");
        grpcLogger.setLevel(Level.ALL);
        BridgingLogHandler handler = new BridgingLogHandler();
        handler.setFormatter(formatter);
        handler.setLevel(Level.ALL);
        HashSet<CallSite> filteredSet = new HashSet<CallSite>();
        for (String annoyingLoggingPath : new String[]{"io.grpc.netty.Utils", "io.grpc.netty.GrpcSslContexts", "io.grpc.InternalChannelz", "io.grpc.Context", "io.grpc.NameResolverRegistry", "io.grpc.LoadBalancerRegistry", "io.grpc.ChannelLogger", "io.grpc.netty.NettyClientHandler"}) {
            filteredSet.add((CallSite)((Object)(shadowPfx + annoyingLoggingPath)));
        }
        handler.setFilter(record -> {
            if (record.getLevel().intValue() >= Level.INFO.intValue()) {
                return true;
            }
            String loggerName = record.getLoggerName();
            if (loggerName == null) {
                return false;
            }
            return !filteredSet.contains(loggerName);
        });
        grpcLogger.addHandler(handler);
    }
}

