/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import com.sun.management.HotSpotDiagnosticMXBean;
import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import io.deephaven.configuration.Configuration;
import io.deephaven.configuration.DataDir;
import io.deephaven.io.logger.Logger;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Predicate;
import javax.management.MBeanServer;

public class HeapDump {
    public static void heapDump() throws IOException {
        HeapDump.heapDump(HeapDump.generateHeapDumpPath());
    }

    public static String generateHeapDumpPath() {
        String name = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())) + ".hprof";
        Path path = DataDir.get().resolve("heapDumps").resolve(name);
        return path.toString();
    }

    public static void heapDump(String filename) throws IOException {
        Files.createDirectories(Path.of(filename, new String[0]).getParent(), new FileAttribute[0]);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        HotSpotDiagnosticMXBean mxBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
        mxBean.dumpHeap(filename, true);
    }

    private static void heapDumpWrapper(String cause, RuntimeException failure, Predicate<RuntimeException> ignore, Logger log) {
        if (ignore != null && ignore.test(failure)) {
            return;
        }
        try {
            String heapDumpPath = HeapDump.generateHeapDumpPath();
            log.fatal().append((CharSequence)(cause + ", generating heap dump to")).append((CharSequence)heapDumpPath).append((CharSequence)": ").append((Throwable)failure).endl();
            HeapDump.heapDump(heapDumpPath);
        }
        catch (Exception e) {
            log.info().append((CharSequence)("Exception while trying to dump heap on assertion failure: " + e.getMessage() + ":\n")).append((Throwable)e).endl();
        }
    }

    public static void setupHeapDumpWithDefaults(Configuration configuration, Predicate<RuntimeException> ignore, Logger log) {
        if (configuration.getBooleanWithDefault("assertion.heapDump", false)) {
            log.info().append((CharSequence)"Heap dump on assertion failures enabled.").endl();
            Assert.setOnAssertionCallback(af -> HeapDump.heapDumpWrapper("Assertion failure", (RuntimeException)af, ignore, log));
        }
        if (configuration.getBooleanWithDefault("require.heapDump", false)) {
            log.info().append((CharSequence)"Heap dump on requirement failures enabled.").endl();
            Require.setOnFailureCallback(rf -> HeapDump.heapDumpWrapper("Requirement failure", (RuntimeException)rf, ignore, log));
        }
    }
}

