/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import io.deephaven.UncheckedDeephavenException;
import io.deephaven.util.MultiException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SafeCloseable
extends AutoCloseable {
    @Override
    public void close();

    public static void closeAll(AutoCloseable ... autoCloseables) {
        SafeCloseable.closeAll(Arrays.asList(autoCloseables).iterator());
    }

    public static <ACT extends AutoCloseable> void closeAll(@NotNull Stream<ACT> stream) {
        SafeCloseable.closeAll(stream.iterator());
    }

    public static <ACT extends AutoCloseable> void closeAll(@NotNull Iterator<ACT> iterator) {
        ArrayList<Exception> exceptions = null;
        while (iterator.hasNext()) {
            AutoCloseable autoCloseable = (AutoCloseable)iterator.next();
            if (autoCloseable == null) continue;
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                if (exceptions == null) {
                    exceptions = new ArrayList<Exception>();
                }
                exceptions.add(e);
            }
        }
        if (exceptions != null) {
            throw new UncheckedDeephavenException("Exception while closing resources", MultiException.maybeWrapInMultiException("Close exceptions for multiple resources", exceptions));
        }
    }

    public static void closeIfNonNull(@Nullable AutoCloseable autoCloseable) {
        if (autoCloseable != null) {
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                throw new UncheckedDeephavenException("Exception while closing resource", e);
            }
        }
    }
}

