/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import io.deephaven.UncheckedDeephavenException;
import io.deephaven.util.MultiException;
import io.deephaven.util.SafeCloseable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SafeCloseableArray<ACT extends AutoCloseable>
implements SafeCloseable {
    private final ACT[] array;

    public SafeCloseableArray(ACT[] entries) {
        this.array = entries;
    }

    @Override
    public final void close() {
        SafeCloseableArray.close(this.array);
    }

    public static <ACT extends AutoCloseable> void close(ACT @NotNull [] array) {
        int length = array.length;
        ArrayList<Exception> exceptions = null;
        for (int ii = 0; ii < length; ++ii) {
            try (ACT ignored = array[ii];){
                array[ii] = null;
                continue;
            }
            catch (Exception e) {
                if (exceptions == null) {
                    exceptions = new ArrayList<Exception>();
                }
                exceptions.add(e);
            }
        }
        if (exceptions != null) {
            throw new UncheckedDeephavenException("Exception while closing resources", MultiException.maybeWrapInMultiException("Close exceptions for multiple resources", (List<? extends Throwable>)exceptions));
        }
    }
}

