/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import io.deephaven.util.SafeCloseable;
import io.deephaven.util.SafeCloseableArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeCloseableList
implements SafeCloseable {
    private final List<AutoCloseable> list = new ArrayList<AutoCloseable>();
    public static final Collector<AutoCloseable, SafeCloseableList, SafeCloseableList> COLLECTOR = new Collector<AutoCloseable, SafeCloseableList, SafeCloseableList>(){

        @Override
        public Supplier<SafeCloseableList> supplier() {
            return SafeCloseableList::new;
        }

        @Override
        public BiConsumer<SafeCloseableList, AutoCloseable> accumulator() {
            return SafeCloseableList::add;
        }

        @Override
        public BinaryOperator<SafeCloseableList> combiner() {
            return (left, right) -> {
                left.addAll(right.list);
                return left;
            };
        }

        @Override
        public Function<SafeCloseableList, SafeCloseableList> finisher() {
            return a -> a;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Set.of(Collector.Characteristics.IDENTITY_FINISH);
        }
    };

    public SafeCloseableList() {
    }

    public SafeCloseableList(AutoCloseable ... entries) {
        this(Arrays.asList(entries));
    }

    public SafeCloseableList(Collection<AutoCloseable> entries) {
        this.list.addAll(entries);
    }

    public final void addAll(@NotNull List<AutoCloseable> closeableList) {
        this.list.addAll(closeableList);
    }

    public final <T extends AutoCloseable> T[] addArray(@Nullable T[] closeables) {
        if (closeables != null) {
            this.list.add(new SafeCloseableArray(closeables));
        }
        return closeables;
    }

    public final <T extends AutoCloseable> T add(T closeable) {
        this.list.add(closeable);
        return closeable;
    }

    public final void clear() {
        this.list.clear();
    }

    @Override
    public final void close() {
        try {
            SafeCloseable.closeAll(this.list.iterator());
        }
        finally {
            this.list.clear();
        }
    }
}

