/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import io.deephaven.util.SafeCloseable;
import java.util.Objects;

public class SafeCloseablePair<A extends AutoCloseable, B extends AutoCloseable>
implements SafeCloseable {
    public final A first;
    public final B second;

    public SafeCloseablePair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public String toString() {
        return "Pair[" + this.first + "," + this.second + "]";
    }

    public boolean equals(Object other) {
        if (!(other instanceof SafeCloseablePair)) {
            return false;
        }
        SafeCloseablePair otherPair = (SafeCloseablePair)other;
        return Objects.equals(this.first, otherPair.first) && Objects.equals(this.second, otherPair.second);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    @Override
    public void close() {
        SafeCloseable.closeAll(new AutoCloseable[]{this.first, this.second});
    }

    public static <AP extends SafeCloseable, BP extends SafeCloseable, A extends AP, B extends BP> SafeCloseablePair<AP, BP> downcast(SafeCloseablePair<A, B> self) {
        return self;
    }

    public static <A extends SafeCloseable, B extends SafeCloseable> SafeCloseablePair<A, B> of(A first, B second) {
        return new SafeCloseablePair<A, B>(first, second);
    }

    public A getFirst() {
        return this.first;
    }

    public B getSecond() {
        return this.second;
    }
}

