/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import io.deephaven.base.log.LogOutput;
import io.deephaven.base.verify.Require;
import io.deephaven.io.logger.Logger;
import io.deephaven.util.function.ThrowingRunnable;
import io.deephaven.util.function.ThrowingSupplier;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jetbrains.annotations.NotNull;

public class Utils {
    public static final String MAC_OPTION_STRING = "\u2325";
    public static final String MAC_COMMAND_STRING = "\u2318";
    public static LogOutput.ObjFormatter<Object> REFERENT_FORMATTER = (logOutput, object) -> logOutput.append((CharSequence)Utils.getSimpleNameFor(object)).append('-').append(System.identityHashCode(object));

    public static void unCheck(ThrowingRunnable<IOException> r) {
        try {
            r.run();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T unCheck(ThrowingSupplier<T, IOException> r) {
        try {
            return r.get();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String unNull(String s) {
        return s != null ? s : "";
    }

    public static void runWithoutInterruption(Logger log, ThrowingRunnable<InterruptedException> thing, String name) {
        while (true) {
            try {
                thing.run();
                return;
            }
            catch (InterruptedException ignore) {
                log.warn().append((CharSequence)"Caught InterruptedException while running ").append((CharSequence)name).endl();
                continue;
            }
            break;
        }
    }

    public static long sleepIgnoringInterruptions(long millisToSleep) {
        long currentTime;
        long startTime = currentTime = System.currentTimeMillis();
        long endTime = currentTime + millisToSleep;
        while (currentTime < endTime) {
            try {
                Thread.sleep(endTime - currentTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            currentTime = System.currentTimeMillis();
        }
        return currentTime - startTime;
    }

    public static boolean isEmptyElement(Element elem, String ... ignoredAttrs) {
        List attrs = elem.getAttributes();
        if (!attrs.isEmpty() && ignoredAttrs.length != 0) {
            List<String> ignored = Arrays.asList(ignoredAttrs);
            if (attrs.stream().anyMatch(attr -> !ignored.contains(attr.getName()))) {
                return false;
            }
        }
        return elem.getChildren().isEmpty();
    }

    public static Element wrapElement(@NotNull String wrapperName, @NotNull Element wrapee) {
        return new Element(wrapperName).addContent((Content)wrapee);
    }

    public static Element unwrapElement(@NotNull String wrapperName, @NotNull Element parentElem) {
        Element wrapper = parentElem.getChild(wrapperName);
        if (wrapper == null) {
            return null;
        }
        return wrapper.getChildren().isEmpty() ? null : (Element)wrapper.getChildren().get(0);
    }

    public static LocalDateTime getLastModifiedTime(File f) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(f.lastModified()), ZoneId.systemDefault());
    }

    public static Comparator<String> getModifiedTimeComparator(File dir, boolean descending) {
        int direction = descending ? -1 : 1;
        return (f1, f2) -> {
            LocalDateTime f2Time;
            LocalDateTime f1Time = Utils.getLastModifiedTime(new File(dir, (String)f1));
            if (f1Time.isBefore(f2Time = Utils.getLastModifiedTime(new File(dir, (String)f2)))) {
                return -direction;
            }
            if (f1Time.isAfter(f2Time)) {
                return direction;
            }
            return 0;
        };
    }

    public static Comparator<File> getModifiedTimeComparator(boolean descending) {
        int direction = descending ? -1 : 1;
        return (f1, f2) -> {
            LocalDateTime f2Time;
            LocalDateTime f1Time = Utils.getLastModifiedTime(f1);
            if (f1Time.isBefore(f2Time = Utils.getLastModifiedTime(f2))) {
                return -direction;
            }
            if (f1Time.isAfter(f2Time)) {
                return direction;
            }
            return 0;
        };
    }

    public static RuntimeException sneakyThrow(Throwable t) {
        if (t == null) {
            throw new NullPointerException();
        }
        Utils.dirtyTrick(t);
        assert (false) : "Can't get here";
        return new RuntimeException(t);
    }

    private static <T extends Throwable> void dirtyTrick(Throwable t) throws T {
        throw t;
    }

    public static URLClassLoader cleanRoom() {
        LinkedHashSet<URL> all = new LinkedHashSet<URL>();
        for (ClassLoader cl = Thread.currentThread().getContextClassLoader(); cl != null; cl = cl.getParent()) {
            if (!(cl instanceof URLClassLoader)) continue;
            for (URL url : ((URLClassLoader)cl).getURLs()) {
                all.add(url);
            }
        }
        return new URLClassLoader(all.toArray(new URL[0]), null);
    }

    public static void ensureClosed(@NotNull AutoCloseable autoCloseable) {
        try {
            autoCloseable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T> void reverseArraySubset(T[] array, int start, int end) {
        if (array == null) {
            return;
        }
        if (start < 0 || end > array.length - 1) {
            throw new IllegalArgumentException("Invalid indices to reverse array: (" + start + ", " + end + ") allowed (0, " + (array.length - 1) + ")");
        }
        int i = start;
        for (int j = end; j > i; --j, ++i) {
            T tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean areFileLinesEqual(Path fileA, Path fileB, int skipLines) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Path changeFileExtension(Path path, String extension) {
        Object fileName = path.getFileName().toString();
        if (((String)fileName).endsWith(extension)) {
            return path;
        }
        int index = ((String)fileName).lastIndexOf(46);
        if (index > 0) {
            fileName = ((String)fileName).substring(0, index);
        }
        fileName = (String)fileName + extension;
        return path.getParent().resolve((String)fileName);
    }

    public static String getSimpleNameFor(@NotNull Object o) {
        return Utils.getSimpleNameFor(o.getClass());
    }

    public static String getSimpleNameFor(@NotNull Class<?> objectClass) {
        String simpleName = objectClass.getSimpleName();
        while (simpleName.isEmpty() && objectClass != null) {
            objectClass = objectClass.getSuperclass();
            simpleName = objectClass.getSimpleName();
        }
        return simpleName;
    }

    public static <T> T castTo(Object o, String name, Class<T> type, int numCallsBelowRequirer) {
        Require.instanceOf((Object)o, (String)name, type, (int)numCallsBelowRequirer);
        return (T)o;
    }

    public static <T> T castTo(Object o, String name, Class<T> type) {
        return Utils.castTo(o, name, type, 1);
    }

    public static String makeReferentDescription(@NotNull Object object) {
        return Utils.getSimpleNameFor(object) + "-" + System.identityHashCode(object);
    }

    public static int getMajorJavaVersion() {
        String versionString = System.getProperty("java.version");
        if (versionString == null) {
            throw new RuntimeException("Unable to determine Java version");
        }
        if (versionString.startsWith("1.8")) {
            return 8;
        }
        if (versionString.startsWith("11")) {
            return 11;
        }
        if (versionString.startsWith("13")) {
            return 13;
        }
        throw new RuntimeException("Unsupported Java version: " + versionString);
    }
}

