/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.codec;

import io.deephaven.base.verify.Require;
import io.deephaven.util.codec.BigDecimalCodec;
import io.deephaven.util.codec.BigIntegerCodec;
import io.deephaven.util.codec.CodecCacheException;
import io.deephaven.util.codec.LocalDateCodec;
import io.deephaven.util.codec.LocalTimeCodec;
import io.deephaven.util.codec.ObjectCodec;
import io.deephaven.util.codec.ZonedDateTimeCodec;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum CodecCache {
    DEFAULT;

    private final Map<String, Map<String, Item>> items = new HashMap<String, Map<String, Item>>();

    public synchronized <TYPE> ObjectCodec<TYPE> getCodec(@NotNull String className, @Nullable String arguments) {
        return this.items.computeIfAbsent((String)className, (Function<String, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getCodec$0(java.lang.String ), (Ljava/lang/String;)Ljava/util/Map;)()).computeIfAbsent(arguments, (Function<String, Item>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getCodec$1(java.lang.String java.lang.String ), (Ljava/lang/String;)Lio/deephaven/util/codec/CodecCache$Item;)((String)className)).codec;
    }

    public static String getDefaultCodecClass(@NotNull Class<?> dataType) {
        if (dataType.equals(LocalDate.class)) {
            return LocalDateCodec.class.getName();
        }
        if (dataType.equals(LocalTime.class)) {
            return LocalTimeCodec.class.getName();
        }
        if (dataType.equals(BigDecimal.class)) {
            return BigDecimalCodec.class.getName();
        }
        if (dataType.equals(BigInteger.class)) {
            return BigIntegerCodec.class.getName();
        }
        if (dataType.equals(ZonedDateTime.class)) {
            return ZonedDateTimeCodec.class.getName();
        }
        return null;
    }

    private static /* synthetic */ Item lambda$getCodec$1(String className, String a) {
        return new Item(className, a);
    }

    private static /* synthetic */ Map lambda$getCodec$0(String cn) {
        return new HashMap();
    }

    private static class Item {
        @NotNull
        private final ObjectCodec<?> codec;

        private Item(@NotNull String className, @Nullable String arguments) {
            Constructor<?> codecConstructor;
            Class<?> codecClass;
            Require.neqNull((Object)className, (String)"className");
            try {
                codecClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new CodecCacheException("Unknown codec class " + className, e);
            }
            try {
                codecConstructor = codecClass.getConstructor(String.class);
            }
            catch (NoSuchMethodException e) {
                throw new CodecCacheException("Codec class " + codecClass + " is missing expected String constructor", e);
            }
            try {
                this.codec = (ObjectCodec)codecConstructor.newInstance(arguments);
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new CodecCacheException("Failed to instantiate codec of type " + codecClass + " from arguments " + arguments, e);
            }
        }
    }
}

