/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.codec;

import io.deephaven.util.EncodingUtil;
import io.deephaven.util.codec.StringKeyedMapCodec;
import java.nio.ByteBuffer;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class StringStringMapCodec
extends StringKeyedMapCodec<String> {
    public StringStringMapCodec(@Nullable String arguments) {
        super(arguments);
    }

    @Override
    int estimateSize(Map<String, String> input) {
        int estimate = 4;
        for (Map.Entry<String, String> entry : input.entrySet()) {
            estimate += entry.getKey().length() + 4;
            estimate += entry.getValue().length() + 4;
        }
        estimate = (int)((double)estimate * 1.1);
        return estimate;
    }

    @Override
    int getValueSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    String decodeValue(ByteBuffer byteBuffer) {
        return EncodingUtil.getUtf8String(byteBuffer);
    }

    @Override
    void encodeValue(ByteBuffer scratch, String value) {
        EncodingUtil.putUtf8String(scratch, value);
    }
}

