/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.codec;

import io.deephaven.util.codec.ObjectCodec;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UTF8StringAsByteArrayCodec
implements ObjectCodec<String> {
    private final int expectedWidth;

    public UTF8StringAsByteArrayCodec(@Nullable String arguments) {
        int size;
        if (arguments == null || arguments.trim().isEmpty()) {
            this.expectedWidth = Integer.MIN_VALUE;
            return;
        }
        String[] tokens = arguments.split(",");
        if (tokens.length == 0) {
            this.expectedWidth = Integer.MIN_VALUE;
            return;
        }
        try {
            size = Integer.parseInt(tokens[0].trim());
            if (tokens.length > 1) {
                throw new IllegalArgumentException("Unexpected additional arguments after first: " + arguments);
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Error parsing column size: " + ex.getMessage(), ex);
        }
        if (size < 1) {
            throw new IllegalArgumentException("Invalid column size: " + size);
        }
        this.expectedWidth = size;
    }

    @Override
    @NotNull
    public byte[] encode(@Nullable String input) {
        if (input == null) {
            throw new IllegalArgumentException(UTF8StringAsByteArrayCodec.class.getSimpleName() + " cannot encode nulls");
        }
        return input.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    @Nullable
    public String decode(@NotNull byte[] input, int offset, int length) {
        return new String(input, offset, length, StandardCharsets.UTF_8);
    }

    @Override
    public int expectedObjectWidth() {
        return this.expectedWidth;
    }
}

