/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.codec;

import io.deephaven.datastructures.util.CollectionUtil;
import io.deephaven.util.codec.ObjectCodec;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZonedDateTimeCodec
implements ObjectCodec<ZonedDateTime> {
    static final long MAX_CONVERTIBLE_SECONDS = 9223372035L;

    public ZonedDateTimeCodec(String args) {
    }

    @Override
    @NotNull
    public byte[] encode(@Nullable ZonedDateTime input) {
        if (input == null) {
            return CollectionUtil.ZERO_LENGTH_BYTE_ARRAY;
        }
        int bufSize = ZonedDateTimeCodec.computeSize(input);
        byte[] buf = new byte[bufSize];
        ByteBuffer bb = ByteBuffer.wrap(buf);
        bb.putLong(ZonedDateTimeCodec.toEpochNano(input));
        String zone = input.getZone().getId();
        bb.putInt(zone.length());
        bb.put(zone.getBytes(StandardCharsets.UTF_8));
        return buf;
    }

    @Override
    @Nullable
    public ZonedDateTime decode(@NotNull byte[] input, int offset, int length) {
        if (length == 0) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.wrap(input, offset, length);
        long nanos = buf.getLong();
        int zidLen = buf.getInt();
        byte[] zidBytes = new byte[zidLen];
        buf.get(zidBytes, 0, zidLen);
        String zid = new String(zidBytes, StandardCharsets.UTF_8);
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(0L, nanos), ZoneId.of(zid));
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int expectedObjectWidth() {
        return Integer.MIN_VALUE;
    }

    private static int computeSize(@NotNull ZonedDateTime val) {
        return 12 + val.getZone().getId().length();
    }

    private static long toEpochNano(@Nullable ZonedDateTime value) {
        if (value == null) {
            return Long.MIN_VALUE;
        }
        return ZonedDateTimeCodec.safeComputeNanos(value.toEpochSecond(), value.getNano());
    }

    private static long safeComputeNanos(long epochSecond, long nanoOfSecond) {
        if (epochSecond > 9223372035L) {
            throw new IllegalArgumentException("Numeric overflow detected during conversion of " + epochSecond + " to nanoseconds");
        }
        return Math.addExact(epochSecond * 1000000000L, nanoOfSecond);
    }
}

