/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.compare;

public class FloatComparisons {
    public static int compare(float lhs, float rhs) {
        if (lhs == rhs) {
            return 0;
        }
        if (lhs == -3.4028235E38f) {
            return -1;
        }
        if (rhs == -3.4028235E38f) {
            return 1;
        }
        if (Float.isNaN(lhs)) {
            if (Float.isNaN(rhs)) {
                return 0;
            }
            return 1;
        }
        if (Float.isNaN(rhs)) {
            return -1;
        }
        return lhs < rhs ? -1 : 1;
    }

    public static boolean eq(float lhs, float rhs) {
        return Float.isNaN(lhs) && Float.isNaN(rhs) || lhs == rhs;
    }

    public static boolean gt(float lhs, float rhs) {
        return FloatComparisons.compare(lhs, rhs) > 0;
    }

    public static boolean lt(float lhs, float rhs) {
        return FloatComparisons.compare(lhs, rhs) < 0;
    }

    public static boolean geq(float lhs, float rhs) {
        return FloatComparisons.compare(lhs, rhs) >= 0;
    }

    public static boolean leq(float lhs, float rhs) {
        return FloatComparisons.compare(lhs, rhs) <= 0;
    }
}

