/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures;

import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class CachingSupplier<OUTPUT_TYPE>
implements Supplier<OUTPUT_TYPE> {
    private final Supplier<OUTPUT_TYPE> internalSupplier;
    private volatile boolean hasCachedResult;
    private OUTPUT_TYPE cachedResult;
    private RuntimeException errorResult;

    public CachingSupplier(@NotNull Supplier<OUTPUT_TYPE> internalSupplier) {
        this.internalSupplier = internalSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OUTPUT_TYPE get() {
        if (!this.hasCachedResult) {
            CachingSupplier cachingSupplier = this;
            synchronized (cachingSupplier) {
                if (!this.hasCachedResult) {
                    try {
                        this.cachedResult = this.internalSupplier.get();
                    }
                    catch (RuntimeException err) {
                        this.errorResult = err;
                    }
                    this.hasCachedResult = true;
                }
            }
        }
        if (this.errorResult != null) {
            throw this.errorResult;
        }
        return this.cachedResult;
    }
}

