/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public class RandomAccessDeque<T>
implements Collection<T> {
    private static final int DEQUE_EXPANSION = 100;
    private Object[] array;
    private int expansion;
    private int start;
    private int end;

    public RandomAccessDeque() {
        this(Collections.emptyList(), 100);
    }

    public RandomAccessDeque(int expansion) {
        this(Collections.emptyList(), expansion);
    }

    public RandomAccessDeque(Collection<T> initialValues) {
        this(initialValues, 100);
    }

    public RandomAccessDeque(Collection<T> initialValues, int expansion) {
        this.getClass().getComponentType();
        this.expansion = expansion;
        this.array = new Object[2 * expansion + initialValues.size()];
        this.start = this.end = expansion;
        Arrays.fill(this.array, null);
        initialValues.forEach(this::addLast);
    }

    @Override
    public int size() {
        return this.end - this.start;
    }

    @Override
    public boolean isEmpty() {
        return this.end == this.start;
    }

    @Override
    public boolean contains(Object o) {
        return this.stream().anyMatch(x -> o == x || o != null && o.equals(x));
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int iStart;
            {
                this.iStart = RandomAccessDeque.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.iStart < RandomAccessDeque.this.end;
            }

            @Override
            public T next() {
                return RandomAccessDeque.this.array[this.iStart++];
            }

            @Override
            public void remove() {
                System.arraycopy(RandomAccessDeque.this.array, this.iStart, RandomAccessDeque.this.array, this.iStart - 1, RandomAccessDeque.this.end - this.iStart);
                --RandomAccessDeque.this.end;
                --this.iStart;
                RandomAccessDeque.this.array[RandomAccessDeque.this.end + 1] = null;
            }
        };
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] result = new Object[this.end - this.start];
        System.arraycopy(this.array, this.start, result, 0, this.end - this.start);
        return result;
    }

    @Override
    @NotNull
    public <T1> T1[] toArray(@NotNull T1[] a) {
        if (a.length < this.end - this.start) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.end - this.start);
        }
        System.arraycopy(this.array, this.start, a, 0, this.end - this.start);
        return a;
    }

    @Override
    public boolean add(T t) {
        this.addLast(t);
        return true;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        HashSet missing = new HashSet(c);
        for (int ii = this.start; ii < this.end; ++ii) {
            if (!missing.remove(this.array[ii]) || !missing.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        c.forEach(this::addLast);
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.removeIf((Predicate<? super T>)((Predicate<Object>)c::contains));
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.removeIf((Predicate<? super T>)((Predicate<Object>)x -> !c.contains(x)));
    }

    @Override
    public void clear() {
        Arrays.fill(this.array, this.start, this.end, null);
        this.end = this.start;
    }

    public void addFirst(T vv) {
        if (this.start == 0) {
            Object[] newArray = new Object[this.array.length + this.expansion];
            Arrays.fill(newArray, 0, this.expansion, null);
            System.arraycopy(this.array, this.start, newArray, this.expansion, this.end - this.start);
            this.start = this.expansion;
            this.end += this.expansion;
            Arrays.fill(newArray, this.end, newArray.length, null);
            this.array = newArray;
        }
        this.array[--this.start] = vv;
    }

    public void addLast(T vv) {
        if (this.end == this.array.length) {
            this.array = Arrays.copyOf(this.array, this.array.length + 100);
        }
        this.array[this.end++] = vv;
    }

    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        boolean modified = false;
        int jj = this.start;
        for (int ii = this.start; ii < this.end; ++ii) {
            if (predicate.test(this.array[ii])) {
                modified = true;
                continue;
            }
            if (ii != jj) {
                this.array[jj++] = this.array[ii];
                continue;
            }
            ++jj;
        }
        Arrays.fill(this.array, jj, this.end, null);
        this.end = jj;
        return modified;
    }

    @Override
    public boolean remove(Object entry) {
        return this.removeIf((Predicate<? super T>)((Predicate<Object>)x -> x == entry || x != null && x.equals(entry)));
    }

    public T get(int index) {
        if (this.start + index >= this.end || index < 0 || this.start + index < this.start) {
            throw new ArrayIndexOutOfBoundsException("index=" + index + ", end=" + this.end + ", start=" + this.start);
        }
        return (T)this.array[this.start + index];
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(new DequeSpliterator(), false);
    }

    @Override
    public Stream<T> parallelStream() {
        return StreamSupport.stream(new DequeSpliterator(), true);
    }

    private class DequeSpliterator
    implements Spliterator<T> {
        int spliterStart;
        int spliterEnd;

        DequeSpliterator() {
            this.spliterStart = RandomAccessDeque.this.start;
            this.spliterEnd = RandomAccessDeque.this.end;
        }

        DequeSpliterator(int spliterStart, int spliterEnd) {
            this.spliterStart = spliterStart;
            this.spliterEnd = spliterEnd;
        }

        @Override
        public Spliterator<T> trySplit() {
            int mid = (this.spliterStart + this.spliterEnd) / 2;
            if (this.spliterStart < mid) {
                int oldStart = this.spliterStart;
                this.spliterStart = mid;
                return new DequeSpliterator(oldStart, mid);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.spliterEnd - this.spliterStart;
        }

        @Override
        public int characteristics() {
            return 17488;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (this.spliterStart < this.spliterEnd) {
                action.accept(RandomAccessDeque.this.array[this.spliterStart++]);
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            while (this.tryAdvance(action)) {
            }
        }
    }
}

