/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures;

import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SegmentedSoftPool<ELEMENT_TYPE> {
    private final int segmentCapacity;
    private final Supplier<ELEMENT_TYPE> creationProcedure;
    private final Consumer<ELEMENT_TYPE> cleanupProcedure;
    private Reference<Segment<ELEMENT_TYPE>> currentSegmentReference;

    public SegmentedSoftPool(int segmentCapacity, @Nullable Supplier<ELEMENT_TYPE> creationProcedure, @Nullable Consumer<ELEMENT_TYPE> cleanupProcedure) {
        this.segmentCapacity = Require.gtZero((int)segmentCapacity, (String)"segmentCapacity");
        this.creationProcedure = creationProcedure;
        this.cleanupProcedure = cleanupProcedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ELEMENT_TYPE take() {
        SegmentedSoftPool segmentedSoftPool = this;
        synchronized (segmentedSoftPool) {
            Segment<ELEMENT_TYPE> currentSegment = this.getCurrentSegment();
            if (currentSegment != null) {
                if (currentSegment.empty()) {
                    Segment<ELEMENT_TYPE> previousSegment = currentSegment.getPrev();
                    if (previousSegment != null) {
                        Assert.assertion((boolean)previousSegment.full(), (String)"previousSegment.full()");
                        currentSegment = previousSegment;
                        this.updateCurrentSegment(currentSegment);
                        return currentSegment.take();
                    }
                } else {
                    return currentSegment.take();
                }
            }
        }
        return this.maybeCreateElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void give(@NotNull ELEMENT_TYPE element) {
        this.maybeCleanElement(Require.neqNull(element, (String)"element"));
        SegmentedSoftPool segmentedSoftPool = this;
        synchronized (segmentedSoftPool) {
            Segment<ELEMENT_TYPE> currentSegment = this.getCurrentSegment();
            if (currentSegment == null) {
                currentSegment = new Segment(this.segmentCapacity, null);
                this.updateCurrentSegment(currentSegment);
            } else if (currentSegment.full()) {
                Segment<ELEMENT_TYPE> nextSegment = currentSegment.getNext();
                if (nextSegment == null) {
                    nextSegment = new Segment<ELEMENT_TYPE>(this.segmentCapacity, currentSegment);
                    currentSegment.setNext(nextSegment);
                } else {
                    Assert.assertion((boolean)nextSegment.empty(), (String)"nextSegment.empty()");
                }
                currentSegment = nextSegment;
                this.updateCurrentSegment(currentSegment);
            }
            currentSegment.give(element);
        }
    }

    private Segment<ELEMENT_TYPE> getCurrentSegment() {
        return this.currentSegmentReference == null ? null : this.currentSegmentReference.get();
    }

    private void updateCurrentSegment(@NotNull Segment<ELEMENT_TYPE> newCurrentSegment) {
        this.currentSegmentReference = newCurrentSegment.getSelfReference();
    }

    private ELEMENT_TYPE maybeCreateElement() {
        if (this.creationProcedure == null) {
            throw new UnsupportedOperationException("Pool exhausted and no creation procedure supplied");
        }
        return this.creationProcedure.get();
    }

    private void maybeCleanElement(@NotNull ELEMENT_TYPE element) {
        if (this.cleanupProcedure != null) {
            this.cleanupProcedure.accept(element);
        }
    }

    private static class Segment<ELEMENT_TYPE>
    extends SoftReference<Segment<ELEMENT_TYPE>> {
        private final ELEMENT_TYPE[] storage;
        private final Reference<Segment<ELEMENT_TYPE>> selfReference;
        private int available;
        private Segment<ELEMENT_TYPE> next;

        private Segment(int capacity, @Nullable Segment<ELEMENT_TYPE> previous) {
            super(previous);
            this.storage = new Object[capacity];
            this.selfReference = new SoftReference<Segment>(this);
        }

        private boolean empty() {
            return this.available == 0;
        }

        private boolean full() {
            return this.available == this.storage.length;
        }

        private ELEMENT_TYPE take() {
            return this.storage[--this.available];
        }

        private void give(@NotNull ELEMENT_TYPE element) {
            this.storage[this.available++] = element;
        }

        private Reference<Segment<ELEMENT_TYPE>> getSelfReference() {
            return this.selfReference;
        }

        private Segment<ELEMENT_TYPE> getNext() {
            return this.next;
        }

        private void setNext(@NotNull Segment<ELEMENT_TYPE> other) {
            Assert.eqNull(this.next, (String)"next");
            this.next = (Segment)Require.neqNull(other, (String)"other");
        }

        private Segment<ELEMENT_TYPE> getPrev() {
            return (Segment)this.get();
        }
    }
}

