/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures;

import gnu.trove.impl.PrimeFinder;
import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeakIdentityHashSet<TYPE> {
    private static final double LOAD_FACTOR = 0.5;
    private static final int NULL_SLOT = -1;
    private static final WeakReference<?> DELETED_REFERENCE = new DeletedReference();
    private WeakReference<? extends TYPE>[] storage;
    private int usedSlots;
    private int freeSlots;
    private int rehashThreshold;

    public WeakIdentityHashSet() {
        this(1, false);
    }

    private WeakIdentityHashSet(int initialCapacity, boolean exact) {
        this.initialize(initialCapacity, exact);
    }

    private void initialize(int capacity, boolean exact) {
        this.storage = null;
        this.usedSlots = 0;
        this.freeSlots = exact ? capacity : PrimeFinder.nextPrime((int)((int)Math.ceil((double)capacity / 0.5)));
        this.rehashThreshold = Math.min(this.freeSlots - 1, (int)Math.floor((double)this.freeSlots * 0.5));
    }

    private void updateAccountingForInsert(boolean usedFreeSlot) {
        if (usedFreeSlot) {
            --this.freeSlots;
        }
        if (++this.usedSlots > this.rehashThreshold || this.freeSlots == 1) {
            int newCapacity = this.usedSlots > this.rehashThreshold ? PrimeFinder.nextPrime((int)(this.storage.length << 1)) : this.storage.length;
            this.rehash(newCapacity);
        }
    }

    private void markSlotDeleted(int slot) {
        this.storage[slot] = DELETED_REFERENCE;
        --this.usedSlots;
    }

    private void rehash(int newCapacity) {
        WeakIdentityHashSet<? extends TYPE> other = new WeakIdentityHashSet<TYPE>(newCapacity, true);
        for (WeakReference<TYPE> weakReference : this.storage) {
            Object value;
            if (weakReference == null || weakReference == DELETED_REFERENCE || (value = weakReference.get()) == null) continue;
            other.add((TYPE)value, (WeakReference<? extends TYPE>)weakReference);
        }
        this.storage = other.storage;
        this.usedSlots = other.usedSlots;
        this.freeSlots = other.freeSlots;
        this.rehashThreshold = other.rehashThreshold;
    }

    public void clear() {
        this.initialize(1, false);
    }

    public boolean add(@NotNull TYPE value) {
        return this.add(value, null);
    }

    public boolean add(@NotNull TYPE value, @Nullable WeakReference<? extends TYPE> valueReference) {
        if (this.storage == null) {
            this.storage = new WeakReference[this.freeSlots];
        }
        int length = this.storage.length;
        int hash = System.identityHashCode(value);
        int probe = 1 + hash % (length - 2);
        int candidateSlot = hash % length;
        boolean foundDeletedSlot = false;
        int firstDeletedSlot = -1;
        while (true) {
            WeakReference<TYPE> candidateReference;
            if ((candidateReference = this.storage[candidateSlot]) == null) {
                this.storage[foundDeletedSlot ? firstDeletedSlot : candidateSlot] = valueReference == null ? new WeakReference<TYPE>(value) : valueReference;
                this.updateAccountingForInsert(!foundDeletedSlot);
                return true;
            }
            if (candidateReference == DELETED_REFERENCE) {
                if (!foundDeletedSlot) {
                    foundDeletedSlot = true;
                    firstDeletedSlot = candidateSlot;
                }
            } else {
                Object candidate = candidateReference.get();
                if (candidate == value) {
                    return false;
                }
                if (candidate == null) {
                    this.markSlotDeleted(candidateSlot);
                    if (!foundDeletedSlot) {
                        foundDeletedSlot = true;
                        firstDeletedSlot = candidateSlot;
                    }
                }
            }
            if ((candidateSlot -= probe) >= 0) continue;
            candidateSlot += length;
        }
    }

    public void forEach(@NotNull Consumer<? super TYPE> action) {
        if (this.storage == null) {
            return;
        }
        int usedSlotsConsumed = 0;
        for (int slotIndex = 0; slotIndex < this.storage.length && usedSlotsConsumed < this.usedSlots; ++slotIndex) {
            WeakReference<TYPE> memberReference = this.storage[slotIndex];
            if (memberReference == null || memberReference == DELETED_REFERENCE) continue;
            Object member = memberReference.get();
            if (member == null) {
                this.markSlotDeleted(slotIndex);
                continue;
            }
            ++usedSlotsConsumed;
            action.accept(member);
        }
    }

    private static final class DeletedReference
    extends WeakReference<Object> {
        private DeletedReference() {
            super(new Object());
            this.clear();
        }

        @Override
        public final Object get() {
            throw new IllegalStateException("DeletedReference cannot be dereferenced");
        }
    }

    public static class Synchronized<TYPE>
    extends WeakIdentityHashSet<TYPE> {
        @Override
        public synchronized void clear() {
            super.clear();
        }

        @Override
        public synchronized boolean add(@NotNull TYPE value) {
            return super.add(value);
        }

        @Override
        public synchronized boolean add(@NotNull TYPE value, @Nullable WeakReference<? extends TYPE> valueReference) {
            return super.add(value, valueReference);
        }

        @Override
        public synchronized void forEach(@NotNull Consumer<? super TYPE> action) {
            super.forEach(action);
        }
    }
}

