/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures.cache;

import io.deephaven.base.ArrayUtil;
import io.deephaven.base.verify.Require;
import io.deephaven.util.datastructures.cache.BaseOffsetLookupCache;
import io.deephaven.util.datastructures.cache.OffsetLookup;
import io.deephaven.util.datastructures.cache.OffsetLookupCache;
import java.lang.reflect.Array;
import org.jetbrains.annotations.NotNull;

public class ArrayBackedOffsetLookupCache<VALUE_TYPE, EXTRA_INPUT_TYPE>
extends BaseOffsetLookupCache<VALUE_TYPE, EXTRA_INPUT_TYPE> {
    private volatile VALUE_TYPE[] cachedValues;

    public ArrayBackedOffsetLookupCache(@NotNull Class<VALUE_TYPE> valueType, @NotNull OffsetLookup<VALUE_TYPE, EXTRA_INPUT_TYPE> lookupFunction) {
        this(valueType, lookupFunction, OffsetLookupCache.createPlaceholder(valueType));
    }

    private ArrayBackedOffsetLookupCache(@NotNull Class<VALUE_TYPE> valueType, @NotNull OffsetLookup<VALUE_TYPE, EXTRA_INPUT_TYPE> lookupFunction, @NotNull VALUE_TYPE nullValue) {
        super(lookupFunction, nullValue, valueType);
        this.cachedValues = (Object[])Array.newInstance(valueType, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VALUE_TYPE get(int index, EXTRA_INPUT_TYPE extra) {
        VALUE_TYPE value;
        Require.geqZero((int)index, (String)"index");
        Object[] localCachedValues = this.cachedValues;
        if (index >= localCachedValues.length || (value = localCachedValues[index]) == null) {
            ArrayBackedOffsetLookupCache arrayBackedOffsetLookupCache = this;
            synchronized (arrayBackedOffsetLookupCache) {
                this.cachedValues = localCachedValues = ArrayUtil.ensureSize((Object[])this.cachedValues, (int)(index + 1), (Class)this.valueType);
                value = localCachedValues[index];
                if (value == null) {
                    value = this.lookupFunction.lookup(index, extra);
                    localCachedValues[index] = value == null ? this.nullValue : value;
                    return value;
                }
            }
        }
        return value == this.nullValue ? null : (VALUE_TYPE)value;
    }

    @Override
    public synchronized void clear() {
        this.cachedValues = (Object[])Array.newInstance(this.valueType, 0);
    }
}

