/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures.cache;

import io.deephaven.base.verify.Require;
import io.deephaven.hash.IntrusiveChainedHashAdapter;
import io.deephaven.hash.KeyedObjectIntrusiveChainedHashMap;
import io.deephaven.hash.KeyedObjectKey;
import io.deephaven.util.datastructures.linked.IntrusiveDoublyLinkedQueue;
import io.deephaven.util.datastructures.linked.IntrusiveDoublyLinkedStructureBase;
import io.deephaven.util.type.TypeUtils;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.jetbrains.annotations.NotNull;

public abstract class BoundedIntrusiveMappingCache<KEY_TYPE, MAPPING_TYPE extends Mapping<KEY_TYPE, MAPPING_TYPE>> {
    final int maximumCachedMappings;
    final KeyedObjectIntrusiveChainedHashMap<KEY_TYPE, MAPPING_TYPE> mappingCache;
    final IntrusiveDoublyLinkedQueue<MAPPING_TYPE> evictionQueue;

    private BoundedIntrusiveMappingCache(int maximumCachedMappings) {
        this.maximumCachedMappings = Require.gtZero((int)maximumCachedMappings, (String)"maximumCachedMappings");
        this.mappingCache = new KeyedObjectIntrusiveChainedHashMap(MappingCacheAdapter.getInstance(), MappingKey.getInstance());
        this.evictionQueue = new IntrusiveDoublyLinkedQueue(EvictionQueueAdapter.getInstance());
    }

    public static String getCacheDeclarationType(Class<?> keyType, Class<?> valueType) {
        String keyClassName = TypeUtils.getBoxedType(keyType).getCanonicalName();
        if (valueType == Byte.TYPE || valueType == Byte.class) {
            return "BoundedIntrusiveMappingCache.ByteImpl<" + keyClassName + ">";
        }
        if (valueType == Short.TYPE || valueType == Short.class) {
            return "BoundedIntrusiveMappingCache.ShortImpl<" + keyClassName + ">";
        }
        if (valueType == Integer.TYPE || valueType == Integer.class) {
            return "BoundedIntrusiveMappingCache.IntegerImpl<" + keyClassName + ">";
        }
        if (valueType == Long.TYPE || valueType == Long.class) {
            return "BoundedIntrusiveMappingCache.LongImpl<" + keyClassName + ">";
        }
        if (valueType == Float.TYPE || valueType == Float.class) {
            return "BoundedIntrusiveMappingCache.FloatImpl<" + keyClassName + ">";
        }
        if (valueType == Double.TYPE || valueType == Double.class) {
            return "BoundedIntrusiveMappingCache.DoubleImpl<" + keyClassName + ">";
        }
        if (valueType == Character.TYPE || valueType == Character.class) {
            return "BoundedIntrusiveMappingCache.CharacterImpl<" + keyClassName + ">";
        }
        String valueClassName = TypeUtils.getBoxedType(valueType).getCanonicalName();
        return "BoundedIntrusiveMappingCache.ObjectImpl<" + keyClassName + "," + valueClassName + ">";
    }

    public static String getCacheInitializer(Class<?> valueType, String maximumCachedMappingsString) {
        if (valueType == Byte.TYPE || valueType == Byte.class) {
            return "new BoundedIntrusiveMappingCache.ByteImpl<>(" + maximumCachedMappingsString + ")";
        }
        if (valueType == Short.TYPE || valueType == Short.class) {
            return "new BoundedIntrusiveMappingCache.ShortImpl<>(" + maximumCachedMappingsString + ")";
        }
        if (valueType == Integer.TYPE || valueType == Integer.class) {
            return "new BoundedIntrusiveMappingCache.IntegerImpl<>(" + maximumCachedMappingsString + ")";
        }
        if (valueType == Long.TYPE || valueType == Long.class) {
            return "new BoundedIntrusiveMappingCache.LongImpl<>(" + maximumCachedMappingsString + ")";
        }
        if (valueType == Float.TYPE || valueType == Float.class) {
            return "new BoundedIntrusiveMappingCache.FloatImpl<>(" + maximumCachedMappingsString + ")";
        }
        if (valueType == Double.TYPE || valueType == Double.class) {
            return "new BoundedIntrusiveMappingCache.DoubleImpl<>(" + maximumCachedMappingsString + ")";
        }
        if (valueType == Character.TYPE || valueType == Character.class) {
            return "new BoundedIntrusiveMappingCache.CharacterImpl<>(" + maximumCachedMappingsString + ")";
        }
        return "new BoundedIntrusiveMappingCache.ObjectImpl<>(" + maximumCachedMappingsString + ")";
    }

    public static class ObjectImpl<KEY_TYPE, VALUE_TYPE>
    extends BoundedIntrusiveMappingCache<KEY_TYPE, ObjectMapping<KEY_TYPE, VALUE_TYPE>> {
        public ObjectImpl(int maximumCachedMappings) {
            super(maximumCachedMappings);
        }

        public VALUE_TYPE computeIfAbsent(KEY_TYPE key, @NotNull Function<KEY_TYPE, VALUE_TYPE> mapper) {
            ObjectMapping mapping = (ObjectMapping)this.mappingCache.get(key);
            if (mapping == null) {
                VALUE_TYPE value = mapper.apply(key);
                if (this.mappingCache.size() >= this.maximumCachedMappings) {
                    mapping = (ObjectMapping)this.evictionQueue.remove();
                    this.mappingCache.remove(mapping.key);
                } else {
                    mapping = new ObjectMapping();
                }
                mapping.initialize(key, value);
                this.mappingCache.add((Object)mapping);
            } else {
                this.evictionQueue.remove(mapping);
            }
            this.evictionQueue.offer(mapping);
            return mapping.value;
        }
    }

    public static class CharacterImpl<KEY_TYPE>
    extends BoundedIntrusiveMappingCache<KEY_TYPE, CharacterMapping<KEY_TYPE>> {
        public CharacterImpl(int maximumCachedMappings) {
            super(maximumCachedMappings);
        }

        public char computeIfAbsent(KEY_TYPE key, @NotNull ToCharacterFunction<KEY_TYPE> mapper) {
            CharacterMapping mapping = (CharacterMapping)this.mappingCache.get(key);
            if (mapping == null) {
                char value = mapper.applyAsCharacter(key);
                if (this.mappingCache.size() >= this.maximumCachedMappings) {
                    mapping = (CharacterMapping)this.evictionQueue.remove();
                    this.mappingCache.remove(mapping.key);
                } else {
                    mapping = new CharacterMapping();
                }
                mapping.initialize(key, value);
                this.mappingCache.add((Object)mapping);
            } else {
                this.evictionQueue.remove(mapping);
            }
            this.evictionQueue.offer(mapping);
            return mapping.value;
        }
    }

    public static class DoubleImpl<KEY_TYPE>
    extends BoundedIntrusiveMappingCache<KEY_TYPE, DoubleMapping<KEY_TYPE>> {
        public DoubleImpl(int maximumCachedMappings) {
            super(maximumCachedMappings);
        }

        public double computeIfAbsent(KEY_TYPE key, @NotNull ToDoubleFunction<KEY_TYPE> mapper) {
            DoubleMapping mapping = (DoubleMapping)this.mappingCache.get(key);
            if (mapping == null) {
                double value = mapper.applyAsDouble(key);
                if (this.mappingCache.size() >= this.maximumCachedMappings) {
                    mapping = (DoubleMapping)this.evictionQueue.remove();
                    this.mappingCache.remove(mapping.key);
                } else {
                    mapping = new DoubleMapping();
                }
                mapping.initialize(key, value);
                this.mappingCache.add((Object)mapping);
            } else {
                this.evictionQueue.remove(mapping);
            }
            this.evictionQueue.offer(mapping);
            return mapping.value;
        }
    }

    public static class FloatImpl<KEY_TYPE>
    extends BoundedIntrusiveMappingCache<KEY_TYPE, FloatMapping<KEY_TYPE>> {
        public FloatImpl(int maximumCachedMappings) {
            super(maximumCachedMappings);
        }

        public float computeIfAbsent(KEY_TYPE key, @NotNull ToFloatFunction<KEY_TYPE> mapper) {
            FloatMapping mapping = (FloatMapping)this.mappingCache.get(key);
            if (mapping == null) {
                float value = mapper.applyAsFloat(key);
                if (this.mappingCache.size() >= this.maximumCachedMappings) {
                    mapping = (FloatMapping)this.evictionQueue.remove();
                    this.mappingCache.remove(mapping.key);
                } else {
                    mapping = new FloatMapping();
                }
                mapping.initialize(key, value);
                this.mappingCache.add((Object)mapping);
            } else {
                this.evictionQueue.remove(mapping);
            }
            this.evictionQueue.offer(mapping);
            return mapping.value;
        }
    }

    public static class LongImpl<KEY_TYPE>
    extends BoundedIntrusiveMappingCache<KEY_TYPE, LongMapping<KEY_TYPE>> {
        public LongImpl(int maximumCachedMappings) {
            super(maximumCachedMappings);
        }

        public long computeIfAbsent(KEY_TYPE key, @NotNull ToLongFunction<KEY_TYPE> mapper) {
            LongMapping mapping = (LongMapping)this.mappingCache.get(key);
            if (mapping == null) {
                long value = mapper.applyAsLong(key);
                if (this.mappingCache.size() >= this.maximumCachedMappings) {
                    mapping = (LongMapping)this.evictionQueue.remove();
                    this.mappingCache.remove(mapping.key);
                } else {
                    mapping = new LongMapping();
                }
                mapping.initialize(key, value);
                this.mappingCache.add((Object)mapping);
            } else {
                this.evictionQueue.remove(mapping);
            }
            this.evictionQueue.offer(mapping);
            return mapping.value;
        }
    }

    public static class FifoIntegerImpl<KEY_TYPE>
    extends BoundedIntrusiveMappingCache<KEY_TYPE, IntegerMapping<KEY_TYPE>> {
        public FifoIntegerImpl(int maximumCachedMappings) {
            super(maximumCachedMappings);
        }

        public int computeIfAbsent(KEY_TYPE key, @NotNull ToIntFunction<KEY_TYPE> mapper) {
            IntegerMapping mapping = (IntegerMapping)this.mappingCache.get(key);
            if (mapping == null) {
                int value = mapper.applyAsInt(key);
                if (this.mappingCache.size() >= this.maximumCachedMappings) {
                    mapping = (IntegerMapping)this.evictionQueue.remove();
                    this.mappingCache.remove(mapping.key);
                } else {
                    mapping = new IntegerMapping();
                }
                mapping.initialize(key, value);
                this.mappingCache.add((Object)mapping);
                this.evictionQueue.offer(mapping);
            }
            return mapping.value;
        }

        public void clear() {
            this.mappingCache.clear();
            this.evictionQueue.clearFast();
        }
    }

    public static class IntegerImpl<KEY_TYPE>
    extends BoundedIntrusiveMappingCache<KEY_TYPE, IntegerMapping<KEY_TYPE>> {
        public IntegerImpl(int maximumCachedMappings) {
            super(maximumCachedMappings);
        }

        public int computeIfAbsent(KEY_TYPE key, @NotNull ToIntFunction<KEY_TYPE> mapper) {
            IntegerMapping mapping = (IntegerMapping)this.mappingCache.get(key);
            if (mapping == null) {
                int value = mapper.applyAsInt(key);
                if (this.mappingCache.size() >= this.maximumCachedMappings) {
                    mapping = (IntegerMapping)this.evictionQueue.remove();
                    this.mappingCache.remove(mapping.key);
                } else {
                    mapping = new IntegerMapping();
                }
                mapping.initialize(key, value);
                this.mappingCache.add((Object)mapping);
            } else {
                this.evictionQueue.remove(mapping);
            }
            this.evictionQueue.offer(mapping);
            return mapping.value;
        }
    }

    public static class ShortImpl<KEY_TYPE>
    extends BoundedIntrusiveMappingCache<KEY_TYPE, ShortMapping<KEY_TYPE>> {
        public ShortImpl(int maximumCachedMappings) {
            super(maximumCachedMappings);
        }

        public short computeIfAbsent(KEY_TYPE key, @NotNull ToShortFunction<KEY_TYPE> mapper) {
            ShortMapping mapping = (ShortMapping)this.mappingCache.get(key);
            if (mapping == null) {
                short value = mapper.applyAsShort(key);
                if (this.mappingCache.size() >= this.maximumCachedMappings) {
                    mapping = (ShortMapping)this.evictionQueue.remove();
                    this.mappingCache.remove(mapping.key);
                } else {
                    mapping = new ShortMapping();
                }
                mapping.initialize(key, value);
                this.mappingCache.add((Object)mapping);
            } else {
                this.evictionQueue.remove(mapping);
            }
            this.evictionQueue.offer(mapping);
            return mapping.value;
        }
    }

    public static class ByteImpl<KEY_TYPE>
    extends BoundedIntrusiveMappingCache<KEY_TYPE, ByteMapping<KEY_TYPE>> {
        public ByteImpl(int maximumCachedMappings) {
            super(maximumCachedMappings);
        }

        public byte computeIfAbsent(KEY_TYPE key, @NotNull ToByteFunction<KEY_TYPE> mapper) {
            ByteMapping mapping = (ByteMapping)this.mappingCache.get(key);
            if (mapping == null) {
                byte value = mapper.applyAsByte(key);
                if (this.mappingCache.size() >= this.maximumCachedMappings) {
                    mapping = (ByteMapping)this.evictionQueue.remove();
                    this.mappingCache.remove(mapping.key);
                } else {
                    mapping = new ByteMapping();
                }
                mapping.initialize(key, value);
                this.mappingCache.add((Object)mapping);
            } else {
                this.evictionQueue.remove(mapping);
            }
            this.evictionQueue.offer(mapping);
            return mapping.value;
        }
    }

    @FunctionalInterface
    public static interface ToCharacterFunction<T> {
        public char applyAsCharacter(T var1);
    }

    @FunctionalInterface
    public static interface ToFloatFunction<T> {
        public float applyAsFloat(T var1);
    }

    @FunctionalInterface
    public static interface ToShortFunction<T> {
        public short applyAsShort(T var1);
    }

    @FunctionalInterface
    public static interface ToByteFunction<T> {
        public byte applyAsByte(T var1);
    }

    private static class EvictionQueueAdapter<KEY_TYPE, MAPPING_TYPE extends Mapping<KEY_TYPE, MAPPING_TYPE>>
    implements IntrusiveDoublyLinkedStructureBase.Adapter<MAPPING_TYPE> {
        private static final EvictionQueueAdapter<?, ?> INSTANCE = new EvictionQueueAdapter();

        private EvictionQueueAdapter() {
        }

        private static <KEY_TYPE, MAPPING_TYPE extends Mapping<KEY_TYPE, MAPPING_TYPE>> EvictionQueueAdapter<KEY_TYPE, MAPPING_TYPE> getInstance() {
            return INSTANCE;
        }

        @Override
        @NotNull
        public MAPPING_TYPE getNext(@NotNull MAPPING_TYPE node) {
            return ((Mapping)node).nextInEvictionQueue;
        }

        @Override
        public void setNext(@NotNull MAPPING_TYPE node, @NotNull MAPPING_TYPE other) {
            ((Mapping)node).nextInEvictionQueue = other;
        }

        @Override
        @NotNull
        public MAPPING_TYPE getPrev(@NotNull MAPPING_TYPE node) {
            return ((Mapping)node).prevInEvictionQueue;
        }

        @Override
        public void setPrev(@NotNull MAPPING_TYPE node, @NotNull MAPPING_TYPE other) {
            ((Mapping)node).prevInEvictionQueue = other;
        }
    }

    private static class MappingCacheAdapter<KEY_TYPE, MAPPING_TYPE extends Mapping<KEY_TYPE, MAPPING_TYPE>>
    implements IntrusiveChainedHashAdapter<MAPPING_TYPE> {
        private static final MappingCacheAdapter<?, ?> INSTANCE = new MappingCacheAdapter();

        private MappingCacheAdapter() {
        }

        private static <KEY_TYPE, MAPPING_TYPE extends Mapping<KEY_TYPE, MAPPING_TYPE>> MappingCacheAdapter<KEY_TYPE, MAPPING_TYPE> getInstance() {
            return INSTANCE;
        }

        public MAPPING_TYPE getNext(@NotNull MAPPING_TYPE self) {
            return ((Mapping)self).nextInMappingCacheBucket;
        }

        public void setNext(@NotNull MAPPING_TYPE self, MAPPING_TYPE next) {
            ((Mapping)self).nextInMappingCacheBucket = next;
        }
    }

    private static class MappingKey<KEY_TYPE, MAPPING_TYPE extends Mapping<KEY_TYPE, MAPPING_TYPE>>
    extends KeyedObjectKey.Basic<KEY_TYPE, MAPPING_TYPE> {
        private static final MappingKey<?, ?> INSTANCE = new MappingKey();

        private MappingKey() {
        }

        private static <KEY_TYPE, MAPPING_TYPE extends Mapping<KEY_TYPE, MAPPING_TYPE>> MappingKey<KEY_TYPE, MAPPING_TYPE> getInstance() {
            return INSTANCE;
        }

        public KEY_TYPE getKey(MAPPING_TYPE mapping) {
            return ((Mapping)mapping).key;
        }
    }

    private static class ObjectMapping<KEY_TYPE, VALUE_TYPE>
    extends Mapping<KEY_TYPE, ObjectMapping<KEY_TYPE, VALUE_TYPE>> {
        private VALUE_TYPE value;

        private ObjectMapping() {
        }

        private void initialize(KEY_TYPE key, VALUE_TYPE value) {
            this.key = key;
            this.value = value;
        }
    }

    private static class CharacterMapping<KEY_TYPE>
    extends Mapping<KEY_TYPE, CharacterMapping<KEY_TYPE>> {
        private char value;

        private CharacterMapping() {
        }

        private void initialize(KEY_TYPE key, char value) {
            this.key = key;
            this.value = value;
        }
    }

    private static class DoubleMapping<KEY_TYPE>
    extends Mapping<KEY_TYPE, DoubleMapping<KEY_TYPE>> {
        private double value;

        private DoubleMapping() {
        }

        private void initialize(KEY_TYPE key, double value) {
            this.key = key;
            this.value = value;
        }
    }

    private static class FloatMapping<KEY_TYPE>
    extends Mapping<KEY_TYPE, FloatMapping<KEY_TYPE>> {
        private float value;

        private FloatMapping() {
        }

        private void initialize(KEY_TYPE key, float value) {
            this.key = key;
            this.value = value;
        }
    }

    private static class LongMapping<KEY_TYPE>
    extends Mapping<KEY_TYPE, LongMapping<KEY_TYPE>> {
        private long value;

        private LongMapping() {
        }

        private void initialize(KEY_TYPE key, long value) {
            this.key = key;
            this.value = value;
        }
    }

    private static class IntegerMapping<KEY_TYPE>
    extends Mapping<KEY_TYPE, IntegerMapping<KEY_TYPE>> {
        private int value;

        private IntegerMapping() {
        }

        private void initialize(KEY_TYPE key, int value) {
            this.key = key;
            this.value = value;
        }
    }

    private static class ShortMapping<KEY_TYPE>
    extends Mapping<KEY_TYPE, ShortMapping<KEY_TYPE>> {
        private short value;

        private ShortMapping() {
        }

        private void initialize(KEY_TYPE key, short value) {
            this.key = key;
            this.value = value;
        }
    }

    private static class ByteMapping<KEY_TYPE>
    extends Mapping<KEY_TYPE, ByteMapping<KEY_TYPE>> {
        private byte value;

        private ByteMapping() {
        }

        private void initialize(KEY_TYPE key, byte value) {
            this.key = key;
            this.value = value;
        }
    }

    static class Mapping<KEY_TYPE, MAPPING_TYPE extends Mapping<KEY_TYPE, MAPPING_TYPE>> {
        KEY_TYPE key;
        MAPPING_TYPE nextInMappingCacheBucket;
        MAPPING_TYPE nextInEvictionQueue = this;
        MAPPING_TYPE prevInEvictionQueue = this;

        Mapping() {
        }
    }
}

