/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures.hash;

import gnu.trove.TLongCollection;
import gnu.trove.function.TLongFunction;
import gnu.trove.impl.PrimeFinder;
import gnu.trove.iterator.TLongLongIterator;
import gnu.trove.map.TLongLongMap;
import gnu.trove.procedure.TLongLongProcedure;
import gnu.trove.procedure.TLongProcedure;
import gnu.trove.set.TLongSet;
import io.deephaven.base.verify.Assert;
import io.deephaven.util.datastructures.hash.TNullableLongLongMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public abstract class HashMapBase
implements TNullableLongLongMap {
    static final int DEFAULT_INITIAL_CAPACITY = 10;
    static final long DEFAULT_NO_ENTRY_VALUE = -1L;
    static final float DEFAULT_LOAD_FACTOR = 0.5f;
    static final long SPECIAL_KEY_FOR_EMPTY_SLOT = 0L;
    static final long REDIRECTED_KEY_FOR_EMPTY_SLOT = -9223372036854775807L;
    static final long SPECIAL_KEY_FOR_DELETED_SLOT = -9223372036854775806L;
    private static final float NEARLY_FULL_LOAD_FACTOR = 0.9f;
    private static final float SIZE_LIMIT_FACTOR1 = 0.85f;
    private static final float SIZE_LIMIT_FACTOR2 = 0.75f;
    private static final float SIZE_LIMIT_FACTOR4 = 0.85f;
    static final int SIZE_LIMIT1 = 912680576;
    static final int SIZE_LIMIT2 = 0x30000000;
    static final int SIZE_LIMIT4 = 912680576;
    private final int desiredInitialCapacity;
    private final float loadFactor;
    final long noEntryValue;
    int size;
    int nonEmptySlots;
    int rehashThreshold;

    HashMapBase(int desiredInitialCapacity, float loadFactor, long noEntryValue) {
        this.desiredInitialCapacity = desiredInitialCapacity;
        this.loadFactor = loadFactor;
        this.noEntryValue = noEntryValue;
        this.size = 0;
        this.nonEmptySlots = 0;
        this.rehashThreshold = 0;
    }

    static long fixKey(long key) {
        Assert.neq((long)key, (String)"key", (long)-9223372036854775807L, (String)"REDIRECTED_KEY_FOR_EMPTY_SLOT");
        Assert.neq((long)key, (String)"key", (long)-9223372036854775806L, (String)"SPECIAL_KEY_FOR_DELETED_SLOT");
        return key == 0L ? -9223372036854775807L : key;
    }

    long[] allocateKeysAndValuesArray(int entriesPerBucket) {
        int desiredNumBuckets = (this.desiredInitialCapacity + entriesPerBucket - 1) / entriesPerBucket;
        int proposedBucketCapacity = PrimeFinder.nextPrime((int)desiredNumBuckets);
        int maxBucketCapacity = HashMapBase.getMaxBucketCapacity(entriesPerBucket);
        int newBucketCapacity = Math.min(proposedBucketCapacity, maxBucketCapacity);
        Assert.leq((long)((long)newBucketCapacity * (long)entriesPerBucket * 2L), (String)"(long)newBucketCapacity * entriesPerBucket * 2", (long)Integer.MAX_VALUE, (String)"Integer.MAX_VALUE");
        int entryCapacity = newBucketCapacity * entriesPerBucket;
        int longCapacity = entryCapacity * 2;
        this.rehashThreshold = (int)((float)entryCapacity * this.loadFactor);
        long[] keysAndValues = new long[longCapacity];
        this.setKeysAndValues(keysAndValues);
        return keysAndValues;
    }

    void rehash(long[] oldKeysAndValues, boolean wantResize, int entriesPerBucket) {
        int newNumLongs;
        int oldNumLongs = oldKeysAndValues.length;
        if (wantResize) {
            int oldBucketCapacity = oldNumLongs / (entriesPerBucket * 2);
            int proposedBucketCapacity = PrimeFinder.nextPrime((int)(oldBucketCapacity * 2));
            int maxBucketCapacity = HashMapBase.getMaxBucketCapacity(entriesPerBucket);
            int newBucketCapacity = Math.min(proposedBucketCapacity, maxBucketCapacity);
            Assert.leq((long)((long)newBucketCapacity * (long)entriesPerBucket * 2L), (String)"(long)newBucketCapacity * entriesPerBucket * 2", (long)Integer.MAX_VALUE, (String)"Integer.MAX_VALUE");
            int newEntryCapacity = newBucketCapacity * entriesPerBucket;
            newNumLongs = newEntryCapacity * 2;
            float loadFactorToUse = newBucketCapacity < maxBucketCapacity ? this.loadFactor : 0.9f;
            this.rehashThreshold = (int)((float)newEntryCapacity * loadFactorToUse);
        } else {
            newNumLongs = oldNumLongs;
        }
        this.size = 0;
        this.nonEmptySlots = 0;
        long[] newKvs = new long[newNumLongs];
        for (int ii = 0; ii < oldKeysAndValues.length; ii += 2) {
            long oldKey = oldKeysAndValues[ii];
            if (oldKey == 0L || oldKey == -9223372036854775806L) continue;
            long oldValue = oldKeysAndValues[ii + 1];
            this.putImplNoTranslate(newKvs, oldKey, oldValue, true);
        }
        this.setKeysAndValues(newKvs);
    }

    void checkSize(int sizeLimit) {
        if (this.size >= sizeLimit) {
            throw new UnsupportedOperationException(String.format("The Hashtable has exceeded its maximum capacity of %d elements", sizeLimit));
        }
    }

    protected abstract long putImplNoTranslate(long[] var1, long var2, long var4, boolean var6);

    protected abstract void setKeysAndValues(long[] var1);

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    final int capacityImpl(long[] keysAndValues) {
        return keysAndValues == null ? 0 : keysAndValues.length / 2;
    }

    final void clearImpl(long[] keysAndValues) {
        this.size = 0;
        this.nonEmptySlots = 0;
        Arrays.fill(keysAndValues, 0L);
    }

    final void resetToNullImpl() {
        this.size = 0;
        this.nonEmptySlots = 0;
        this.rehashThreshold = 0;
    }

    public final long getNoEntryKey() {
        throw new UnsupportedOperationException();
    }

    public final long getNoEntryValue() {
        return this.noEntryValue;
    }

    final long[] keysOrValuesImpl(long[] kv, long[] space, boolean wantValues) {
        int sz = this.size;
        long[] result = space != null && space.length >= sz ? space : new long[sz];
        int nextIndex = 0;
        for (int ii = 0; ii < kv.length && nextIndex < sz; ii += 2) {
            long key = kv[ii];
            if (key == 0L || key == -9223372036854775806L) continue;
            long resultEntry = wantValues ? kv[ii + 1] : (key == -9223372036854775807L ? 0L : key);
            result[nextIndex++] = resultEntry;
        }
        return result;
    }

    final TLongLongIterator iteratorImpl(long[] kv) {
        return kv == null ? new NullIterator() : new Iterator(kv);
    }

    private static int getMaxBucketCapacity(int entriesPerBucket) {
        switch (entriesPerBucket) {
            case 1: {
                return 0x3FFFFFDD;
            }
            case 2: {
                return 0x1FFFFFFD;
            }
            case 4: {
                return 0xFFFFFC7;
            }
        }
        throw new UnsupportedOperationException("Unexpected entriesPerBucket " + entriesPerBucket);
    }

    public boolean increment(long key) {
        throw new UnsupportedOperationException();
    }

    public boolean adjustValue(long key, long amount) {
        throw new UnsupportedOperationException();
    }

    public long adjustOrPutValue(long key, long adjust_amount, long put_amount) {
        throw new UnsupportedOperationException();
    }

    public boolean containsValue(long val) {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(long key) {
        throw new UnsupportedOperationException();
    }

    public TLongSet keySet() {
        throw new UnsupportedOperationException();
    }

    public boolean forEachKey(TLongProcedure procedure) {
        throw new UnsupportedOperationException();
    }

    public boolean forEachValue(TLongProcedure procedure) {
        throw new UnsupportedOperationException();
    }

    public boolean forEachEntry(TLongLongProcedure procedure) {
        throw new UnsupportedOperationException();
    }

    public void transformValues(TLongFunction function) {
        throw new UnsupportedOperationException();
    }

    public boolean retainEntries(TLongLongProcedure procedure) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map<? extends Long, ? extends Long> map) {
        throw new UnsupportedOperationException();
    }

    public void putAll(TLongLongMap map) {
        throw new UnsupportedOperationException();
    }

    public TLongCollection valueCollection() {
        return null;
    }

    static long mix64(long key) {
        key ^= key >>> 30;
        key *= -4658895280553007687L;
        key ^= key >>> 27;
        key *= -7723592293110705685L;
        key ^= key >>> 31;
        return key;
    }

    static int probe1(long key, int range) {
        long badHash = key ^ key >>> 32;
        return (int)((badHash & Long.MAX_VALUE) % (long)range);
    }

    static int probe2(long key, int range) {
        long mixHash = HashMapBase.mix64(key);
        return (int)((mixHash & Long.MAX_VALUE) % (long)range);
    }

    static {
        HashSet<Long> hs = new HashSet<Long>();
        hs.add(Long.MIN_VALUE);
        hs.add(0L);
        hs.add(-9223372036854775807L);
        hs.add(-9223372036854775806L);
        Assert.eq((int)hs.size(), (String)"hs.size()", (int)4, (String)"4");
        int longsPerEntry = 2;
        for (int entriesPerBucket : new int[]{1, 2, 4}) {
            long mbc = HashMapBase.getMaxBucketCapacity(entriesPerBucket);
            Assert.leq((long)(mbc * (long)entriesPerBucket * 2L), (String)"mbc * entriesPerBucket * longsPerEntry", (long)Integer.MAX_VALUE, (String)"Integer.MAX_VALUE");
        }
    }

    private static class Iterator
    implements TLongLongIterator {
        private final long[] keysAndValues;
        private long currentKey;
        private long currentValue;
        private int nextIndex;

        public Iterator(long[] kv) {
            this.keysAndValues = kv;
            this.nextIndex = this.findOccupiedSlot(0);
        }

        public boolean hasNext() {
            return this.nextIndex < this.keysAndValues.length;
        }

        public void advance() {
            Assert.lt((int)this.nextIndex, (String)"nextIndex", (int)this.keysAndValues.length, (String)"keysAndValues.length");
            long key = this.keysAndValues[this.nextIndex];
            this.currentKey = key == -9223372036854775807L ? 0L : key;
            this.currentValue = this.keysAndValues[this.nextIndex + 1];
            this.nextIndex = this.findOccupiedSlot(this.nextIndex + 2);
        }

        private int findOccupiedSlot(int beginSlot) {
            long key;
            while (beginSlot < this.keysAndValues.length && ((key = this.keysAndValues[beginSlot]) == 0L || key == -9223372036854775806L)) {
                beginSlot += 2;
            }
            return beginSlot;
        }

        public long key() {
            return this.currentKey;
        }

        public long value() {
            return this.currentValue;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public long setValue(long val) {
            throw new UnsupportedOperationException();
        }
    }

    private static class NullIterator
    implements TLongLongIterator {
        private NullIterator() {
        }

        public long key() {
            throw new UnsupportedOperationException();
        }

        public long value() {
            throw new UnsupportedOperationException();
        }

        public long setValue(long val) {
            throw new UnsupportedOperationException();
        }

        public void advance() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

