/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures.hash;

import io.deephaven.util.datastructures.hash.HashMapBase;

public abstract class HashMapK1V1
extends HashMapBase {
    HashMapK1V1(int desiredInitialCapacity, float loadFactor, long noEntryValue) {
        super(desiredInitialCapacity, loadFactor, noEntryValue);
    }

    final long putImpl(long[] kvs, long key, long value, boolean insertOnly) {
        if (kvs == null) {
            kvs = this.allocateKeysAndValuesArray(1);
        }
        long fixedKey = HashMapK1V1.fixKey(key);
        return this.putImplNoTranslate(kvs, fixedKey, value, insertOnly);
    }

    @Override
    protected final long putImplNoTranslate(long[] kvs, long key, long value, boolean insertOnly) {
        int location = HashMapK1V1.getLocationFor(kvs, key);
        if (location >= 0) {
            long oldValue = kvs[location + 1];
            if (!insertOnly) {
                kvs[location + 1] = value;
            }
            return oldValue;
        }
        location = -location - 1;
        ++this.size;
        this.checkSize(912680576);
        if (kvs[location] == 0L) {
            ++this.nonEmptySlots;
        }
        kvs[location] = key;
        kvs[location + 1] = value;
        if (this.nonEmptySlots >= this.rehashThreshold) {
            boolean wantResize = this.size >= this.nonEmptySlots * 2 / 3;
            this.rehash(kvs, wantResize, 1);
        }
        return this.noEntryValue;
    }

    final long getImpl(long[] kvs, long key) {
        if (kvs == null) {
            return this.noEntryValue;
        }
        int location = HashMapK1V1.getLocationFor(kvs, key = HashMapK1V1.fixKey(key));
        if (location < 0) {
            return this.noEntryValue;
        }
        return kvs[location + 1];
    }

    final long removeImpl(long[] kvs, long key) {
        if (kvs == null) {
            return this.noEntryValue;
        }
        int location = HashMapK1V1.getLocationFor(kvs, key = HashMapK1V1.fixKey(key));
        if (location < 0) {
            return this.noEntryValue;
        }
        --this.size;
        kvs[location] = -9223372036854775806L;
        return kvs[location + 1];
    }

    private static int getLocationFor(long[] kvs, long target) {
        int length = kvs.length;
        int numBuckets = length / 2;
        int bucketProbe = HashMapK1V1.probe1(target, numBuckets);
        int probe = bucketProbe * 2;
        long cKey0 = kvs[probe];
        if (cKey0 == target) {
            return probe;
        }
        if (cKey0 == 0L) {
            return -probe - 1;
        }
        int priorDeletedSlot = cKey0 == -9223372036854775806L ? probe : -1;
        int offset = (1 + HashMapK1V1.probe2(target, numBuckets - 2)) * 2;
        int probeStart = probe;
        while (true) {
            if ((probe = (int)(((long)probe + (long)offset) % (long)length)) == probeStart) {
                throw new IllegalStateException("Wrapped around? Impossible.");
            }
            cKey0 = kvs[probe];
            if (cKey0 == target) {
                return probe;
            }
            if (cKey0 == 0L) {
                if (priorDeletedSlot != -1) {
                    return -priorDeletedSlot - 1;
                }
                return -probe - 1;
            }
            if (priorDeletedSlot != -1 || cKey0 != -9223372036854775806L) continue;
            priorDeletedSlot = probe;
        }
    }
}

