/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures.hash;

import io.deephaven.util.datastructures.hash.HashMapBase;

public abstract class HashMapK2V2
extends HashMapBase {
    HashMapK2V2(int desiredInitialCapacity, float loadFactor, long noEntryValue) {
        super(desiredInitialCapacity, loadFactor, noEntryValue);
    }

    final long putImpl(long[] kvs, long key, long value, boolean insertOnly) {
        if (kvs == null) {
            kvs = this.allocateKeysAndValuesArray(2);
        }
        long fixedKey = HashMapK2V2.fixKey(key);
        return this.putImplNoTranslate(kvs, fixedKey, value, insertOnly);
    }

    @Override
    protected final long putImplNoTranslate(long[] kvs, long key, long value, boolean insertOnly) {
        int location = HashMapK2V2.getLocationFor(kvs, key);
        if (location >= 0) {
            long oldValue = kvs[location + 1];
            if (!insertOnly) {
                kvs[location + 1] = value;
            }
            return oldValue;
        }
        location = -location - 1;
        ++this.size;
        this.checkSize(0x30000000);
        if (kvs[location] == 0L) {
            ++this.nonEmptySlots;
        }
        kvs[location] = key;
        kvs[location + 1] = value;
        if (this.nonEmptySlots >= this.rehashThreshold) {
            boolean wantResize = this.size >= this.nonEmptySlots * 2 / 3;
            this.rehash(kvs, wantResize, 2);
        }
        return this.noEntryValue;
    }

    final long getImpl(long[] kvs, long key) {
        if (kvs == null) {
            return this.noEntryValue;
        }
        int location = HashMapK2V2.getLocationFor(kvs, key = HashMapK2V2.fixKey(key));
        if (location < 0) {
            return this.noEntryValue;
        }
        return kvs[location + 1];
    }

    final long removeImpl(long[] kvs, long key) {
        if (kvs == null) {
            return this.noEntryValue;
        }
        int location = HashMapK2V2.getLocationFor(kvs, key = HashMapK2V2.fixKey(key));
        if (location < 0) {
            return this.noEntryValue;
        }
        --this.size;
        kvs[location] = -9223372036854775806L;
        return kvs[location + 1];
    }

    private static int getLocationFor(long[] kvs, long target) {
        int length = kvs.length;
        int numBuckets = length / 4;
        int bucketProbe = HashMapK2V2.probe1(target, numBuckets);
        int probe = bucketProbe * 4;
        long cKey0 = kvs[probe];
        if (cKey0 == target) {
            return probe;
        }
        if (cKey0 == 0L) {
            return -probe - 1;
        }
        long cKey1 = kvs[probe + 2];
        if (cKey1 == target) {
            return probe + 2;
        }
        if (cKey1 == 0L) {
            return -(probe + 2) - 1;
        }
        int priorDeletedSlot = cKey0 == -9223372036854775806L ? probe : (cKey1 == -9223372036854775806L ? probe + 2 : -1);
        int offset = (1 + HashMapK2V2.probe2(target, numBuckets - 2)) * 4;
        int probeStart = probe;
        while (true) {
            if ((probe = (int)(((long)probe + (long)offset) % (long)length)) == probeStart) {
                throw new IllegalStateException("Wrapped around? Impossible.");
            }
            cKey0 = kvs[probe];
            if (cKey0 == target) {
                return probe;
            }
            if (cKey0 == 0L) {
                if (priorDeletedSlot != -1) {
                    return -priorDeletedSlot - 1;
                }
                return -probe - 1;
            }
            cKey1 = kvs[probe + 2];
            if (cKey1 == target) {
                return probe + 2;
            }
            if (cKey1 == 0L) {
                if (priorDeletedSlot != -1) {
                    return -priorDeletedSlot - 1;
                }
                return -(probe + 2) - 1;
            }
            if (priorDeletedSlot != -1) continue;
            if (cKey0 == -9223372036854775806L) {
                priorDeletedSlot = probe;
                continue;
            }
            if (cKey1 != -9223372036854775806L) continue;
            priorDeletedSlot = probe + 2;
        }
    }
}

