/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures.hash;

import io.deephaven.util.datastructures.hash.HashMapBase;

public abstract class HashMapK4V4
extends HashMapBase {
    HashMapK4V4(int desiredInitialCapacity, float loadFactor, long noEntryValue) {
        super(desiredInitialCapacity, loadFactor, noEntryValue);
    }

    final long putImpl(long[] kvs, long key, long value, boolean insertOnly) {
        if (kvs == null) {
            kvs = this.allocateKeysAndValuesArray(4);
        }
        long fixedKey = HashMapK4V4.fixKey(key);
        return this.putImplNoTranslate(kvs, fixedKey, value, insertOnly);
    }

    @Override
    protected final long putImplNoTranslate(long[] kvs, long key, long value, boolean insertOnly) {
        int location = HashMapK4V4.getLocationFor(kvs, key);
        if (location >= 0) {
            long oldValue = kvs[location + 1];
            if (!insertOnly) {
                kvs[location + 1] = value;
            }
            return oldValue;
        }
        location = -location - 1;
        ++this.size;
        this.checkSize(912680576);
        if (kvs[location] == 0L) {
            ++this.nonEmptySlots;
        }
        kvs[location] = key;
        kvs[location + 1] = value;
        if (this.nonEmptySlots >= this.rehashThreshold) {
            boolean wantResize = this.size >= this.nonEmptySlots * 2 / 3;
            this.rehash(kvs, wantResize, 4);
        }
        return this.noEntryValue;
    }

    final long getImpl(long[] kvs, long key) {
        if (kvs == null) {
            return this.noEntryValue;
        }
        int location = HashMapK4V4.getLocationFor(kvs, key = HashMapK4V4.fixKey(key));
        if (location < 0) {
            return this.noEntryValue;
        }
        return kvs[location + 1];
    }

    final long removeImpl(long[] kvs, long key) {
        if (kvs == null) {
            return this.noEntryValue;
        }
        int location = HashMapK4V4.getLocationFor(kvs, key = HashMapK4V4.fixKey(key));
        if (location < 0) {
            return this.noEntryValue;
        }
        --this.size;
        kvs[location] = -9223372036854775806L;
        return kvs[location + 1];
    }

    private static int getLocationFor(long[] kvs, long target) {
        int length = kvs.length;
        int numBuckets = length / 8;
        int bucketProbe = HashMapK4V4.probe1(target, numBuckets);
        int probe = bucketProbe * 8;
        long cKey0 = kvs[probe];
        if (cKey0 == target) {
            return probe;
        }
        if (cKey0 == 0L) {
            return -probe - 1;
        }
        long cKey1 = kvs[probe + 2];
        if (cKey1 == target) {
            return probe + 2;
        }
        if (cKey1 == 0L) {
            return -(probe + 2) - 1;
        }
        long cKey2 = kvs[probe + 4];
        if (cKey2 == target) {
            return probe + 4;
        }
        if (cKey2 == 0L) {
            return -(probe + 4) - 1;
        }
        long cKey3 = kvs[probe + 6];
        if (cKey3 == target) {
            return probe + 6;
        }
        if (cKey3 == 0L) {
            return -(probe + 6) - 1;
        }
        int priorDeletedSlot = cKey0 == -9223372036854775806L ? probe : (cKey1 == -9223372036854775806L ? probe + 2 : (cKey2 == -9223372036854775806L ? probe + 4 : (cKey3 == -9223372036854775806L ? probe + 6 : -1)));
        int offset = (1 + HashMapK4V4.probe2(target, numBuckets - 2)) * 8;
        int probeStart = probe;
        while (true) {
            if ((probe = (int)(((long)probe + (long)offset) % (long)length)) == probeStart) {
                throw new IllegalStateException("Wrapped around? Impossible.");
            }
            cKey0 = kvs[probe];
            if (cKey0 == target) {
                return probe;
            }
            if (cKey0 == 0L) {
                if (priorDeletedSlot != -1) {
                    return -priorDeletedSlot - 1;
                }
                return -probe - 1;
            }
            cKey1 = kvs[probe + 2];
            if (cKey1 == target) {
                return probe + 2;
            }
            if (cKey1 == 0L) {
                if (priorDeletedSlot != -1) {
                    return -priorDeletedSlot - 1;
                }
                return -(probe + 2) - 1;
            }
            cKey2 = kvs[probe + 4];
            if (cKey2 == target) {
                return probe + 4;
            }
            if (cKey2 == 0L) {
                if (priorDeletedSlot != -1) {
                    return -priorDeletedSlot - 1;
                }
                return -(probe + 4) - 1;
            }
            cKey3 = kvs[probe + 6];
            if (cKey3 == target) {
                return probe + 6;
            }
            if (cKey3 == 0L) {
                if (priorDeletedSlot != -1) {
                    return -priorDeletedSlot - 1;
                }
                return -(probe + 6) - 1;
            }
            if (priorDeletedSlot != -1) continue;
            if (cKey0 == -9223372036854775806L) {
                priorDeletedSlot = probe;
                continue;
            }
            if (cKey1 == -9223372036854775806L) {
                priorDeletedSlot = probe + 2;
                continue;
            }
            if (cKey2 == -9223372036854775806L) {
                priorDeletedSlot = probe + 4;
                continue;
            }
            if (cKey3 != -9223372036854775806L) continue;
            priorDeletedSlot = probe + 6;
        }
    }
}

