/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures.intrusive;

import gnu.trove.set.hash.TIntHashSet;
import io.deephaven.base.verify.Assert;
import io.deephaven.util.annotations.TestUseOnly;
import io.deephaven.util.annotations.VisibleForTesting;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class IntrusiveSoftLRU<T> {
    private static final SoftReference<?> NULL = new SoftReference<Object>(null);
    private final Adapter<T> adapter;
    private final int maxCapacity;
    private int size;
    private int[] nexts;
    private int[] prevs;
    private SoftReference<T>[] softReferences;
    private int tail;

    private static <T> SoftReference<T> getNull() {
        return NULL;
    }

    public IntrusiveSoftLRU(@NotNull Adapter<T> adapter, int initialCapacity, int maxCapacity) {
        Assert.gt((int)maxCapacity, (String)"maxCapacity", (int)1);
        Assert.leq((int)initialCapacity, (String)"initialCapacity", (int)maxCapacity, (String)"maxCapacity");
        this.maxCapacity = maxCapacity;
        this.adapter = adapter;
        this.tail = 0;
        this.size = 0;
        if (initialCapacity == maxCapacity) {
            this.initializeLinks();
        }
        this.softReferences = new SoftReference[initialCapacity];
        Arrays.fill(this.softReferences, IntrusiveSoftLRU.getNull());
    }

    public synchronized void touch(@NotNull T itemToTouch) {
        if (this.softReferences.length == this.maxCapacity) {
            this.touchLRU(itemToTouch);
        } else {
            this.touchSimple(itemToTouch);
        }
    }

    public synchronized void clear() {
        Arrays.fill(this.softReferences, IntrusiveSoftLRU.getNull());
    }

    @TestUseOnly
    int currentCapacity() {
        return this.softReferences.length;
    }

    private void initializeLinks() {
        this.size = this.maxCapacity;
        this.nexts = new int[this.maxCapacity];
        this.prevs = new int[this.maxCapacity];
        this.nexts[0] = this.maxCapacity - 1;
        for (int i = 1; i < this.maxCapacity; ++i) {
            this.nexts[i] = i - 1;
            this.prevs[i - 1] = i;
        }
        this.prevs[this.maxCapacity - 1] = 0;
    }

    private void touchLRU(@NotNull T itemToTouch) {
        int slot = this.adapter.getSlot(itemToTouch);
        if (slot < 0 || slot >= this.currentCapacity() || this.softReferences[slot].get() != itemToTouch) {
            this.adapter.setSlot(itemToTouch, this.tail);
            this.softReferences[this.tail] = this.adapter.getOwner(itemToTouch);
            this.tail = this.prevs[this.tail];
        } else if (slot != this.tail) {
            int head = this.nexts[this.tail];
            if (slot != head) {
                int next;
                int prev = this.prevs[slot];
                this.nexts[prev] = next = this.nexts[slot];
                this.prevs[next] = prev;
                this.nexts[slot] = head;
                this.nexts[this.tail] = slot;
                this.prevs[head] = slot;
                this.prevs[slot] = this.tail;
            }
        } else {
            this.tail = this.prevs[this.tail];
        }
    }

    private void touchSimple(@NotNull T itemToTouch) {
        int slot = this.adapter.getSlot(itemToTouch);
        if (slot < 0 || slot >= this.currentCapacity() || this.softReferences[slot].get() != itemToTouch) {
            if (this.size < this.softReferences.length) {
                int slotForItem = this.size++;
                this.adapter.setSlot(itemToTouch, slotForItem);
                this.softReferences[slotForItem] = this.adapter.getOwner(itemToTouch);
            } else {
                this.doResize();
                this.touch(itemToTouch);
            }
        }
    }

    private void doResize() {
        int nullsFound = 0;
        for (int refIdx = 0; refIdx < this.softReferences.length; ++refIdx) {
            T object = this.softReferences[refIdx].get();
            if (object == null) {
                ++nullsFound;
                continue;
            }
            if (nullsFound <= 0) continue;
            this.softReferences[refIdx - nullsFound] = this.softReferences[refIdx];
            this.adapter.setSlot(object, refIdx - nullsFound);
        }
        if (nullsFound > 0) {
            this.size -= nullsFound;
            Assert.lt((int)this.size, (String)"size", (int)this.softReferences.length, (String)"softReferences.length");
            Arrays.fill(this.softReferences, this.size, this.softReferences.length, IntrusiveSoftLRU.getNull());
            return;
        }
        int oldCapacity = this.softReferences.length;
        int newCapacity = Math.min(oldCapacity << 1, this.maxCapacity);
        this.softReferences = Arrays.copyOf(this.softReferences, newCapacity);
        Arrays.fill(this.softReferences, oldCapacity, newCapacity, IntrusiveSoftLRU.getNull());
        if (newCapacity == this.maxCapacity) {
            this.initializeLinks();
        }
    }

    @VisibleForTesting
    synchronized boolean verifyLRU(int numStored) {
        int i;
        HashSet<T> refsVisited = new HashSet<T>();
        TIntHashSet visited = new TIntHashSet();
        int v = this.tail;
        for (i = 0; i < this.nexts.length; ++i) {
            if (!visited.add(v) || !refsVisited.add(this.softReferences[v].get())) {
                return false;
            }
            v = this.nexts[v];
        }
        if (v != this.tail) {
            return false;
        }
        if (visited.size() != numStored) {
            return false;
        }
        for (i = 0; i < this.prevs.length; ++i) {
            if (!visited.remove(v)) {
                return false;
            }
            v = this.prevs[v];
        }
        return v == this.tail;
    }

    @TestUseOnly
    void evict(int refIdx) {
        if (refIdx < 0 || refIdx > this.softReferences.length || this.softReferences[refIdx] == IntrusiveSoftLRU.getNull()) {
            return;
        }
        this.softReferences[refIdx].clear();
    }

    @TestUseOnly
    int size() {
        return this.size;
    }

    public static interface Node<T extends Node<T>> {
        public SoftReference<T> getOwner();

        public int getSlot();

        public void setSlot(int var1);

        public static class Adapter<T extends Node<T>>
        implements io.deephaven.util.datastructures.intrusive.IntrusiveSoftLRU$Adapter<T> {
            private static final io.deephaven.util.datastructures.intrusive.IntrusiveSoftLRU$Adapter<?> INSTANCE = new Adapter();

            public static <T extends Node<T>> io.deephaven.util.datastructures.intrusive.IntrusiveSoftLRU$Adapter<T> getInstance() {
                return INSTANCE;
            }

            @Override
            public SoftReference<T> getOwner(@NotNull T cachedObject) {
                return cachedObject.getOwner();
            }

            @Override
            public int getSlot(@NotNull T cachedObject) {
                return cachedObject.getSlot();
            }

            @Override
            public void setSlot(@NotNull T cachedObject, int slot) {
                cachedObject.setSlot(slot);
            }
        }

        public static class Impl<T extends Impl<T>>
        implements Node<T> {
            private final SoftReference<T> owner = new SoftReference<Impl>(this);
            private int slot = -1;

            protected Impl() {
            }

            @Override
            public SoftReference<T> getOwner() {
                return this.owner;
            }

            @Override
            public int getSlot() {
                return this.slot;
            }

            @Override
            public void setSlot(int slot) {
                this.slot = slot;
            }
        }
    }

    public static interface Adapter<T> {
        public SoftReference<T> getOwner(T var1);

        public int getSlot(T var1);

        public void setSlot(T var1, int var2);
    }
}

