/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.datastructures.linked;

import io.deephaven.util.datastructures.linked.IntrusiveDoublyLinkedStructureBase;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntrusiveDoublyLinkedQueue<VALUE_TYPE>
extends IntrusiveDoublyLinkedStructureBase<VALUE_TYPE>
implements Iterable<VALUE_TYPE> {
    private VALUE_TYPE head;
    private int size;

    public IntrusiveDoublyLinkedQueue(@NotNull IntrusiveDoublyLinkedStructureBase.Adapter<VALUE_TYPE> adapter) {
        super(adapter);
    }

    public final boolean isEmpty() {
        return this.head == null;
    }

    public final int size() {
        return this.size;
    }

    public final void transferBeforeHeadFrom(@NotNull IntrusiveDoublyLinkedQueue<VALUE_TYPE> other) {
        this.transferFrom(other, true);
    }

    public final void transferAfterTailFrom(@NotNull IntrusiveDoublyLinkedQueue<VALUE_TYPE> other) {
        this.transferFrom(other, false);
    }

    private void transferFrom(@NotNull IntrusiveDoublyLinkedQueue<VALUE_TYPE> other, boolean front) {
        if (!this.compatible(other)) {
            throw new UnsupportedOperationException(this + ": Attempted to transfer from incompatible queue " + other);
        }
        if (other.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.head = other.head;
        } else {
            VALUE_TYPE tail = this.getPrev(this.head);
            VALUE_TYPE otherTail = this.getPrev(other.head);
            this.setNext(tail, other.head);
            this.setPrev(other.head, tail);
            this.setNext(otherTail, this.head);
            this.setPrev(this.head, otherTail);
            if (front) {
                this.head = other.head;
            }
        }
        this.size += other.size;
        other.head = null;
        other.size = 0;
    }

    public final boolean offer(@NotNull VALUE_TYPE node) {
        if (this.isEmpty()) {
            this.head = node;
        } else {
            this.linkBefore(node, this.head);
        }
        ++this.size;
        return true;
    }

    public final void insert(@NotNull VALUE_TYPE node, int offset) {
        if (offset < 0 || offset > this.size) {
            throw new IllegalArgumentException("Invalid offset " + offset + ", must be in [0, size(" + this.size + ")]");
        }
        if (offset == this.size) {
            this.offer(node);
            return;
        }
        VALUE_TYPE curr = this.head;
        for (int currOffset = 0; currOffset < offset; ++currOffset) {
            curr = this.getNext(curr);
        }
        this.linkBefore(node, curr);
        if (curr == this.head) {
            this.head = node;
        }
        ++this.size;
    }

    public final void insertBefore(@NotNull VALUE_TYPE node, @Nullable VALUE_TYPE other) {
        if (other == null) {
            this.offer(node);
        } else {
            this.linkBefore(node, other);
        }
    }

    @Nullable
    public final VALUE_TYPE peek() {
        return this.head;
    }

    @Nullable
    public final VALUE_TYPE poll() {
        if (this.isEmpty()) {
            return null;
        }
        VALUE_TYPE node = this.head;
        this.head = this.isLinked(this.head) ? this.getNext(this.head) : null;
        --this.size;
        return this.unlink(node);
    }

    @NotNull
    public final VALUE_TYPE remove() {
        VALUE_TYPE result = this.poll();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    public final boolean remove(@NotNull VALUE_TYPE node) {
        if (this.head == node) {
            if (this.isLinked(node)) {
                this.head = this.getNext(node);
                this.unlink(node);
            } else {
                this.head = null;
            }
        } else if (this.isLinked(node)) {
            this.unlink(node);
        } else {
            return false;
        }
        --this.size;
        return true;
    }

    public final void clear() {
        while (null != this.poll()) {
        }
    }

    public final void clearFast() {
        this.head = null;
        this.size = 0;
    }

    public final boolean contains(@NotNull VALUE_TYPE node) {
        return this.head == node || this.isLinked(node);
    }

    @Override
    @NotNull
    public Iterator<VALUE_TYPE> iterator() {
        return new IteratorImpl();
    }

    @Override
    public Spliterator<VALUE_TYPE> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 272);
    }

    @NotNull
    public Stream<VALUE_TYPE> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    private class IteratorImpl
    implements Iterator<VALUE_TYPE> {
        private VALUE_TYPE next;
        private VALUE_TYPE current;

        private IteratorImpl() {
            this.next = IntrusiveDoublyLinkedQueue.this.head;
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public VALUE_TYPE next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            Object currentNext = IntrusiveDoublyLinkedQueue.this.getNext(this.current);
            this.next = currentNext == IntrusiveDoublyLinkedQueue.this.head ? null : currentNext;
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            IntrusiveDoublyLinkedQueue.this.remove(this.current);
            this.current = null;
        }
    }
}

