/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.files;

import io.deephaven.base.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class FileHelper {
    private FileHelper() {
    }

    public static String getCanonicalForm(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean deleteRecursivelyOnNFS(File file, String excludePattern) {
        Pattern pattern = excludePattern == null ? null : Pattern.compile(excludePattern);
        return FileHelper.deleteRecursivelyOnNFS(new File(file.getParentFile(), "." + file.getName() + ".trash"), file, pattern);
    }

    public static boolean deleteRecursivelyOnNFS(File file, Pattern excludePattern) {
        return FileHelper.deleteRecursivelyOnNFS(new File(file.getParentFile(), "." + file.getName() + ".trash"), file, excludePattern);
    }

    public static boolean deleteRecursivelyOnNFS(File trashFile, File fileToBeDeleted, @Nullable Pattern excludePattern) {
        if (excludePattern != null && excludePattern.matcher(fileToBeDeleted.getName()).matches()) {
            return true;
        }
        if (fileToBeDeleted.isDirectory()) {
            File[] contents = FileUtils.missingSafeListFiles((File)fileToBeDeleted);
            boolean excluded = false;
            for (File childFile : contents) {
                excluded = FileHelper.deleteRecursivelyOnNFS(trashFile, childFile, excludePattern) || excluded;
            }
            if (!excluded && !fileToBeDeleted.delete()) {
                throw new FileDeletionException("Failed to delete expected empty directory " + fileToBeDeleted.getAbsolutePath());
            }
            return excluded;
        }
        if (fileToBeDeleted.exists()) {
            if (!fileToBeDeleted.renameTo(trashFile)) {
                throw new FileDeletionException("Failed to move file " + fileToBeDeleted.getAbsolutePath() + " to temporary location " + trashFile.getAbsolutePath());
            }
            if (!trashFile.delete()) {
                throw new FileDeletionException("Failed to delete temporary location " + trashFile.getAbsolutePath() + " for file " + fileToBeDeleted.getAbsolutePath());
            }
            return false;
        }
        return true;
    }

    public static class FileDeletionException
    extends RuntimeException {
        public FileDeletionException() {
        }

        public FileDeletionException(String message) {
            super(message);
        }

        public FileDeletionException(String message, Throwable cause) {
            super(message, cause);
        }

        public FileDeletionException(Throwable cause) {
            super(cause);
        }
    }
}

