/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.pool;

import io.deephaven.base.LockFreeArrayQueue;
import io.deephaven.base.MathUtil;
import io.deephaven.base.verify.Require;
import io.deephaven.io.logger.Logger;
import io.deephaven.util.pool.PoolEx;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class ThreadSafeFixedSizePool<T>
implements PoolEx<T> {
    public static final int MIN_SIZE = 7;
    private static final int SPIN_COUNT = 10000;
    protected final LockFreeArrayQueue<T> pool;
    private final Consumer<T> clearingProcedure;
    private final String logPfx;
    private final Logger log;
    volatile long nextGiveLog = 0L;
    volatile long nextTakeLog = 0L;

    private ThreadSafeFixedSizePool(int size, @Nullable Supplier<T> factory, Consumer<T> clearingProcedure, Logger log, String logPfx) {
        Require.geq((int)size, (String)"size", (int)7, (String)"MIN_SIZE");
        Require.requirement((log == null == (logPfx == null) ? 1 : 0) != 0, (String)"log and logPfx must either both be null, or both non-null");
        this.clearingProcedure = clearingProcedure;
        this.log = log;
        this.logPfx = logPfx;
        this.pool = new LockFreeArrayQueue(MathUtil.ceilLog2((int)(size + 2)));
        if (factory == null) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            T element = factory.get();
            while (!this.pool.enqueue(element)) {
            }
        }
    }

    public ThreadSafeFixedSizePool(int size, Supplier<T> factory, Consumer<T> clearingProcedure) {
        this(size, factory, clearingProcedure, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void give(T item) {
        long dt;
        long now;
        if (null == item) {
            return;
        }
        if (null != this.clearingProcedure) {
            this.clearingProcedure.accept(item);
        }
        if (this.pool.enqueue(item)) {
            return;
        }
        int spins = 0;
        int yields = 0;
        long t0 = this.log != null ? System.nanoTime() / 1000L : 0L;
        try {
            while (!this.pool.enqueue(item)) {
                if (++spins <= 10000) continue;
                ++yields;
                if (this.log != null && (now = System.nanoTime() / 1000L) > this.nextGiveLog) {
                    this.nextGiveLog = now + 100000L - now % 100000L;
                    dt = now - t0;
                    this.log.warn().append((CharSequence)this.logPfx).append((CharSequence)": give() can't enqueue returned item, yield count = ").append(yields).endl();
                }
                Thread.yield();
                spins = 0;
            }
        }
        finally {
            if (this.log != null && (now = System.nanoTime() / 1000L) > this.nextGiveLog) {
                this.nextGiveLog = now + 100000L - now % 100000L;
                dt = now - t0;
                this.log.warn().append((CharSequence)this.logPfx).append((CharSequence)": give() took ").append(dt).append((CharSequence)" micros, with ").append(yields).append((CharSequence)" yields and ").append(spins).append((CharSequence)" additional spins").endl();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T take() {
        Object item = this.pool.dequeue();
        if (item != null) {
            return (T)item;
        }
        int spins = 0;
        int yields = 0;
        long t0 = this.log != null ? System.nanoTime() / 1000L : 0L;
        try {
            while ((item = this.pool.dequeue()) == null) {
                long now;
                if (++spins <= 10000) continue;
                ++yields;
                if (this.log != null && (now = System.nanoTime() / 1000L) > this.nextTakeLog) {
                    this.nextTakeLog = now + 100000L - now % 100000L;
                    long dt = now - t0;
                    this.log.warn().append((CharSequence)this.logPfx).append((CharSequence)": take() can't dequeue from pool, waiting for ").append(dt).append((CharSequence)" micros, yield count = ").append(yields).endl();
                }
                Thread.yield();
                spins = 0;
            }
            Object object = item;
            return (T)object;
        }
        finally {
            long now;
            if (this.log != null && (now = System.nanoTime() / 1000L) > this.nextTakeLog) {
                this.nextTakeLog = now + 100000L - now % 100000L;
                long dt = now - t0;
                this.log.warn().append((CharSequence)this.logPfx).append((CharSequence)": take() took ").append(dt).append((CharSequence)" micros, with ").append(yields).append((CharSequence)" yields and ").append(spins).append((CharSequence)" additional spins").endl();
            }
        }
    }

    @Override
    public T tryTake() {
        return (T)this.pool.dequeue();
    }
}

