/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.process;

import io.deephaven.configuration.Configuration;
import io.deephaven.io.logger.Logger;
import io.deephaven.util.process.BaseProcessEnvironment;
import io.deephaven.util.process.DefaultFatalErrorReporter;
import io.deephaven.util.process.LoggerShutdownTask;
import io.deephaven.util.process.ProcessEnvironment;
import io.deephaven.util.process.ShutdownManager;
import io.deephaven.util.process.ShutdownManagerImpl;
import org.jetbrains.annotations.NotNull;

public class DefaultProcessEnvironment
extends BaseProcessEnvironment {
    private DefaultProcessEnvironment(@NotNull String mainClassName, @NotNull Logger log) {
        super(new ShutdownManagerImpl(), new DefaultFatalErrorReporter(), mainClassName, log);
    }

    @Override
    public void onStartup() {
        this.log.info().append((CharSequence)this.mainClassName).append((CharSequence)": starting up").endl();
        this.shutdownManager.registerTask(ShutdownManager.OrderingCategory.LAST, new LoggerShutdownTask());
        this.shutdownManager.addShutdownHookToRuntime();
    }

    @Override
    public void onShutdown() {
        this.log.warn().append((CharSequence)this.mainClassName).append((CharSequence)": shutting down").endl();
        this.shutdownManager.maybeInvokeTasks();
    }

    static class Factory
    implements ProcessEnvironment.Factory {
        Factory() {
        }

        @Override
        public ProcessEnvironment make(@NotNull Configuration configuration, @NotNull String mainClassName, @NotNull Logger log) {
            return new DefaultProcessEnvironment(mainClassName, log);
        }
    }
}

