/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.process;

import io.deephaven.util.process.ShutdownManager;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public abstract class OnetimeShutdownTask
implements ShutdownManager.Task {
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    public final boolean isShutdown() {
        return this.isShutdown.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void invoke() {
        if (this.isShutdown()) {
            return;
        }
        AtomicBoolean atomicBoolean = this.isShutdown;
        synchronized (atomicBoolean) {
            if (this.isShutdown()) {
                return;
            }
            this.isShutdown.set(true);
            this.shutdown();
            this.isShutdown.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void awaitShutdown() {
        AtomicBoolean atomicBoolean = this.isShutdown;
        synchronized (atomicBoolean) {
            while (!this.isShutdown()) {
                try {
                    this.isShutdown.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void awaitShutdown(long waitMillis, Runnable task) {
        AtomicBoolean atomicBoolean = this.isShutdown;
        synchronized (atomicBoolean) {
            while (!this.isShutdown()) {
                try {
                    this.isShutdown.wait(waitMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.isShutdown()) continue;
                task.run();
            }
        }
    }

    protected abstract void shutdown();

    public static OnetimeShutdownTask adapt(final @NotNull Runnable shutdown) {
        return new OnetimeShutdownTask(){

            @Override
            protected void shutdown() {
                shutdown.run();
            }
        };
    }
}

