/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.reference;

import io.deephaven.base.reference.CleanupReference;
import io.deephaven.base.verify.Require;
import io.deephaven.configuration.Configuration;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.util.Utils;
import io.deephaven.util.annotations.TestUseOnly;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import org.jetbrains.annotations.NotNull;

public class CleanupReferenceProcessor {
    private static final Logger log = LoggerFactory.getLogger(CleanupReferenceProcessor.class);
    private static final boolean LOG_CLEANED_REFERENCES = Configuration.getInstance().getBooleanWithDefault("CleanupReferenceProcessor.logCleanedReferences", false);
    private final String name;
    private final long shutdownCheckDelayMillis;
    private final ExceptionHandler exceptionHandler;
    private volatile ReferenceQueue<?> referenceQueue;
    private Thread cleanerThread;

    @NotNull
    public static CleanupReferenceProcessor getDefault() {
        return Instance.DEFAULT.cleanupReferenceProcessor;
    }

    public CleanupReferenceProcessor(@NotNull String name, long shutdownCheckDelayMillis, @NotNull ExceptionHandler exceptionHandler) {
        this.name = (String)Require.neqNull((Object)name, (String)"name");
        this.shutdownCheckDelayMillis = Require.geqZero((long)shutdownCheckDelayMillis, (String)"shutdownDelayCheckMillis");
        this.exceptionHandler = (ExceptionHandler)Require.neqNull((Object)exceptionHandler, (String)"exceptionHandler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RT> ReferenceQueue<RT> getReferenceQueue() {
        ReferenceQueue<Object> localQueue = this.referenceQueue;
        if (localQueue == null) {
            CleanupReferenceProcessor cleanupReferenceProcessor = this;
            synchronized (cleanupReferenceProcessor) {
                localQueue = this.referenceQueue;
                if (localQueue == null) {
                    this.referenceQueue = localQueue = new ReferenceQueue();
                    this.cleanerThread = new Thread((Runnable)new DrainQueue(localQueue), "CleanupReferenceProcessor-" + this.name + "-drainingThread");
                    this.cleanerThread.setDaemon(true);
                    this.cleanerThread.start();
                }
            }
        }
        return localQueue;
    }

    @TestUseOnly
    public final synchronized void resetForUnitTests() {
        this.referenceQueue = null;
        if (this.cleanerThread != null) {
            this.cleanerThread.interrupt();
            this.cleanerThread = null;
        }
    }

    private class DrainQueue
    implements Runnable {
        private final ReferenceQueue<?> localQueue;

        private DrainQueue(ReferenceQueue<?> localQueue) {
            this.localQueue = localQueue;
        }

        @Override
        public void run() {
            while (this.localQueue == CleanupReferenceProcessor.this.referenceQueue) {
                Reference<?> reference;
                try {
                    reference = this.localQueue.remove(CleanupReferenceProcessor.this.shutdownCheckDelayMillis);
                }
                catch (InterruptedException ignored) {
                    continue;
                }
                if (!(reference instanceof CleanupReference)) continue;
                try {
                    if (LOG_CLEANED_REFERENCES) {
                        log.info().append((CharSequence)"CleanupReferenceProcessor-").append((CharSequence)CleanupReferenceProcessor.this.name).append((CharSequence)", cleaning ").append(Utils.REFERENT_FORMATTER, reference).endl();
                    }
                    ((CleanupReference)reference).cleanup();
                }
                catch (Exception e) {
                    CleanupReferenceProcessor.this.exceptionHandler.accept(log, (CleanupReference)reference, e);
                }
            }
        }
    }

    public static interface ExceptionHandler {
        public void accept(@NotNull Logger var1, @NotNull CleanupReference<?> var2, @NotNull Exception var3);
    }

    private static enum Instance {
        DEFAULT(new CleanupReferenceProcessor("default", 1000L, (l, r, e) -> l.warn().append((CharSequence)Thread.currentThread().getName()).append((CharSequence)": Exception thrown from cleanup of ").append(Utils.REFERENT_FORMATTER, (Object)r).append((CharSequence)": ").append((Throwable)e).endl()));

        private final CleanupReferenceProcessor cleanupReferenceProcessor;

        private Instance(CleanupReferenceProcessor cleanupReferenceProcessor) {
            this.cleanupReferenceProcessor = (CleanupReferenceProcessor)Require.neqNull((Object)cleanupReferenceProcessor, (String)"cleanupReferenceProcessor");
        }
    }
}

