/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.text;

import io.deephaven.base.verify.Require;

public class Indenter {
    private static final String ONE_LEVEL_INDENT = "    ";
    private String indentString = "    ";
    private int level = 1;

    public Indenter() {
    }

    public Indenter(int level) {
        this();
        while (this.level < level) {
            this.increaseLevel();
        }
        while (this.level > level) {
            this.decreaseLevel();
        }
    }

    public Indenter increaseLevel() {
        this.indentString = this.indentString + ONE_LEVEL_INDENT;
        ++this.level;
        return this;
    }

    public Indenter increaseLevel(int levels) {
        for (int ii = 0; ii < levels; ++ii) {
            this.increaseLevel();
        }
        return this;
    }

    public Indenter decreaseLevel() {
        Require.geq((int)this.level, (String)"level", (int)1, (String)"1");
        this.indentString = this.indentString.substring(0, this.indentString.length() - ONE_LEVEL_INDENT.length());
        --this.level;
        return this;
    }

    public Indenter decreaseLevel(int levels) {
        for (int ii = 0; ii < levels; ++ii) {
            this.decreaseLevel();
        }
        return this;
    }

    public StringBuilder indent(StringBuilder destination, String block) {
        String[] lines = block.split("\n");
        int length = lines.length;
        if (length > 0 && lines[length - 1].length() == 0) {
            --length;
        }
        for (int i = 0; i < length; ++i) {
            destination.append(this.indentString).append(lines[i]).append("\n");
        }
        return destination;
    }

    public String toString() {
        return this.indentString;
    }
}

