/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.type;

import io.deephaven.base.verify.Require;
import io.deephaven.util.QueryConstants;
import io.deephaven.util.type.TypeUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class ArrayTypeUtils {
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Boolean[] EMPTY_BOOLEANBOXED_ARRAY = new Boolean[0];

    public static ArrayAccessor getArrayAccessor(Object array) {
        Class<?> c = array.getClass();
        if (c.equals(Boolean[].class)) {
            return new BooleanArrayAccessor((Boolean[])array);
        }
        if (c.equals(byte[].class)) {
            return new ByteArrayAccessor((byte[])array);
        }
        if (c.equals(char[].class)) {
            return new CharArrayAccessor((char[])array);
        }
        if (c.equals(double[].class)) {
            return new DoubleArrayAccessor((double[])array);
        }
        if (c.equals(float[].class)) {
            return new FloatArrayAccessor((float[])array);
        }
        if (c.equals(int[].class)) {
            return new IntArrayAccessor((int[])array);
        }
        if (c.equals(long[].class)) {
            return new LongArrayAccessor((long[])array);
        }
        if (c.equals(short[].class)) {
            return new ShortArrayAccessor((short[])array);
        }
        return new ObjectArrayAccessor<Object>((Object[])array);
    }

    public static ArrayAccessor createArrayAccessor(Object element, int size) {
        if (element == null) {
            return new ObjectArrayAccessor<Object>(new Object[size]);
        }
        Class<?> c = element.getClass();
        if (c.equals(Boolean.TYPE) || c.equals(Boolean.class)) {
            return new BooleanArrayAccessor(ArrayTypeUtils.booleanNullArray(size));
        }
        if (c.equals(Byte.TYPE) || c.equals(Byte.class)) {
            return new ByteArrayAccessor(ArrayTypeUtils.byteNullArray(size));
        }
        if (c.equals(Character.TYPE) || c.equals(Character.class)) {
            return new CharArrayAccessor(ArrayTypeUtils.charNullArray(size));
        }
        if (c.equals(Double.TYPE) || c.equals(Double.class)) {
            return new DoubleArrayAccessor(ArrayTypeUtils.doubleNullArray(size));
        }
        if (c.equals(Float.TYPE) || c.equals(Float.class)) {
            return new FloatArrayAccessor(ArrayTypeUtils.floatNullArray(size));
        }
        if (c.equals(Integer.TYPE) || c.equals(Integer.class)) {
            return new IntArrayAccessor(ArrayTypeUtils.intNullArray(size));
        }
        if (c.equals(Long.TYPE) || c.equals(Long.class)) {
            return new LongArrayAccessor(ArrayTypeUtils.longNullArray(size));
        }
        if (c.equals(Short.TYPE) || c.equals(Short.class)) {
            return new ShortArrayAccessor(ArrayTypeUtils.shortNullArray(size));
        }
        return new ObjectArrayAccessor<Object>((Object[])Array.newInstance(c, size));
    }

    public static int[] intNullArray(int size) {
        int[] result = new int[size];
        Arrays.fill(result, Integer.MIN_VALUE);
        return result;
    }

    public static Boolean[] booleanNullArray(int size) {
        Object[] result = new Boolean[size];
        Arrays.fill(result, QueryConstants.NULL_BOOLEAN);
        return result;
    }

    public static byte[] byteNullArray(int size) {
        byte[] result = new byte[size];
        Arrays.fill(result, (byte)-128);
        return result;
    }

    public static char[] charNullArray(int size) {
        char[] result = new char[size];
        Arrays.fill(result, '\uffff');
        return result;
    }

    public static double[] doubleNullArray(int size) {
        double[] result = new double[size];
        Arrays.fill(result, -1.7976931348623157E308);
        return result;
    }

    public static float[] floatNullArray(int size) {
        float[] result = new float[size];
        Arrays.fill(result, -3.4028235E38f);
        return result;
    }

    public static long[] longNullArray(int size) {
        long[] result = new long[size];
        Arrays.fill(result, Long.MIN_VALUE);
        return result;
    }

    public static short[] shortNullArray(int size) {
        short[] result = new short[size];
        Arrays.fill(result, (short)Short.MIN_VALUE);
        return result;
    }

    public static Object toArray(Collection<?> objects, Class elementType) {
        if (elementType == Boolean.TYPE) {
            elementType = Boolean.class;
        }
        Object result = Array.newInstance(elementType, objects.size());
        ArrayAccessor accessor = ArrayTypeUtils.getArrayAccessor(result);
        int i = 0;
        for (Object object : objects) {
            accessor.set(i++, object);
        }
        return result;
    }

    public static Object boxedToPrimitive(Set<?> objects, Class type) {
        Iterator<?> it = objects.iterator();
        if (objects.isEmpty()) {
            Class<?> primitiveType = TypeUtils.getUnboxedType(type);
            if (primitiveType == null) {
                return Array.newInstance(type, 0);
            }
            return Array.newInstance(primitiveType, 0);
        }
        Object current = it.next();
        ArrayAccessor resultAccessor = ArrayTypeUtils.createArrayAccessor(current, objects.size());
        int i = 0;
        resultAccessor.set(i++, current);
        while (it.hasNext()) {
            current = it.next();
            resultAccessor.set(i++, current);
        }
        return resultAccessor.getArray();
    }

    public static ArrayAccessor getArrayAccessorFromArray(Object arrayPrototype, int size) {
        Class<?> c = arrayPrototype.getClass();
        if (c.equals(boolean[].class)) {
            return new BooleanArrayAccessor(ArrayTypeUtils.booleanNullArray(size));
        }
        if (c.equals(byte[].class)) {
            return new ByteArrayAccessor(ArrayTypeUtils.byteNullArray(size));
        }
        if (c.equals(char[].class)) {
            return new CharArrayAccessor(ArrayTypeUtils.charNullArray(size));
        }
        if (c.equals(double[].class)) {
            return new DoubleArrayAccessor(ArrayTypeUtils.doubleNullArray(size));
        }
        if (c.equals(float[].class)) {
            return new FloatArrayAccessor(ArrayTypeUtils.floatNullArray(size));
        }
        if (c.equals(int[].class)) {
            return new IntArrayAccessor(ArrayTypeUtils.intNullArray(size));
        }
        if (c.equals(long[].class)) {
            return new LongArrayAccessor(ArrayTypeUtils.longNullArray(size));
        }
        if (c.equals(short[].class)) {
            return new ShortArrayAccessor(ArrayTypeUtils.shortNullArray(size));
        }
        return new ObjectArrayAccessor<Object>((Object[])Array.newInstance(c.getComponentType(), size));
    }

    public static Object toArray(Collection<?> objects) {
        if (objects.size() == 0) {
            return ArrayTypeUtils.toArray(objects, Object.class);
        }
        Object prototype = objects.iterator().next();
        if (prototype == null) {
            return ArrayTypeUtils.toArray(objects, Object.class);
        }
        Class<?> ubType = TypeUtils.getUnboxedType(prototype.getClass());
        return ArrayTypeUtils.toArray(objects, ubType == null ? prototype.getClass() : ubType);
    }

    public static ArrayAccessor getAccessorForElementType(Class componentType, int size) {
        if (componentType.equals(Boolean.TYPE) || componentType.equals(Boolean.class)) {
            return new BooleanArrayAccessor(ArrayTypeUtils.booleanNullArray(size));
        }
        if (componentType.equals(Byte.TYPE) || componentType.equals(Byte.class)) {
            return new ByteArrayAccessor(ArrayTypeUtils.byteNullArray(size));
        }
        if (componentType.equals(Character.TYPE) || componentType.equals(Character.class)) {
            return new CharArrayAccessor(ArrayTypeUtils.charNullArray(size));
        }
        if (componentType.equals(Double.TYPE) || componentType.equals(Double.class)) {
            return new DoubleArrayAccessor(ArrayTypeUtils.doubleNullArray(size));
        }
        if (componentType.equals(Float.TYPE) || componentType.equals(Float.class)) {
            return new FloatArrayAccessor(ArrayTypeUtils.floatNullArray(size));
        }
        if (componentType.equals(Integer.TYPE) || componentType.equals(Integer.class)) {
            return new IntArrayAccessor(ArrayTypeUtils.intNullArray(size));
        }
        if (componentType.equals(Long.TYPE) || componentType.equals(Long.class)) {
            return new LongArrayAccessor(ArrayTypeUtils.longNullArray(size));
        }
        if (componentType.equals(Short.TYPE) || componentType.equals(Short.class)) {
            return new ShortArrayAccessor(ArrayTypeUtils.shortNullArray(size));
        }
        return new ObjectArrayAccessor<Object>((Object[])Array.newInstance(componentType, size));
    }

    public static Character[] getBoxedArray(char[] referenceData) {
        Character[] result = new Character[referenceData.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = referenceData[i] == '\uffff' ? null : Character.valueOf(referenceData[i]);
        }
        return result;
    }

    public static Boolean[] getBoxedArray(boolean[] referenceData) {
        Boolean[] result = new Boolean[referenceData.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = referenceData[i];
        }
        return result;
    }

    public static Integer[] getBoxedArray(int[] referenceData) {
        Integer[] result = new Integer[referenceData.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = referenceData[i] == Integer.MIN_VALUE ? null : Integer.valueOf(referenceData[i]);
        }
        return result;
    }

    public static Byte[] getBoxedArray(byte[] referenceData) {
        Byte[] result = new Byte[referenceData.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = referenceData[i] == -128 ? null : Byte.valueOf(referenceData[i]);
        }
        return result;
    }

    public static Double[] getBoxedArray(double[] referenceData) {
        Double[] result = new Double[referenceData.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = referenceData[i] == -1.7976931348623157E308 ? null : Double.valueOf(referenceData[i]);
        }
        return result;
    }

    public static Float[] getBoxedArray(float[] referenceData) {
        Float[] result = new Float[referenceData.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = referenceData[i] == -3.4028235E38f ? null : Float.valueOf(referenceData[i]);
        }
        return result;
    }

    public static Long[] getBoxedArray(long[] referenceData) {
        Long[] result = new Long[referenceData.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = referenceData[i] == Long.MIN_VALUE ? null : Long.valueOf(referenceData[i]);
        }
        return result;
    }

    public static Short[] getBoxedArray(short[] referenceData) {
        Short[] result = new Short[referenceData.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = referenceData[i] == Short.MIN_VALUE ? null : Short.valueOf(referenceData[i]);
        }
        return result;
    }

    public static Object getUnboxedArray(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> c = value.getClass();
        if (c.equals(Byte[].class)) {
            return ArrayTypeUtils.getUnboxedArray((Byte[])value);
        }
        if (c.equals(Character[].class)) {
            return ArrayTypeUtils.getUnboxedArray((Character[])value);
        }
        if (c.equals(Double[].class)) {
            return ArrayTypeUtils.getUnboxedArray((Double[])value);
        }
        if (c.equals(Float[].class)) {
            return ArrayTypeUtils.getUnboxedArray((Float[])value);
        }
        if (c.equals(Integer[].class)) {
            return ArrayTypeUtils.getUnboxedArray((Integer[])value);
        }
        if (c.equals(Long[].class)) {
            return ArrayTypeUtils.getUnboxedArray((Long[])value);
        }
        if (c.equals(Short[].class)) {
            return ArrayTypeUtils.getUnboxedArray((Short[])value);
        }
        return value;
    }

    public static byte[] getUnboxedArray(Byte[] boxedArray) {
        byte[] result = new byte[boxedArray.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = boxedArray[i] != null ? (int)boxedArray[i].byteValue() : -128;
        }
        return result;
    }

    public static char[] getUnboxedArray(Character[] boxedArray) {
        char[] result = new char[boxedArray.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = boxedArray[i] != null ? (int)boxedArray[i].charValue() : 65535;
        }
        return result;
    }

    public static double[] getUnboxedArray(Double[] boxedArray) {
        double[] result = new double[boxedArray.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = boxedArray[i] != null ? boxedArray[i] : -1.7976931348623157E308;
        }
        return result;
    }

    public static float[] getUnboxedArray(Float[] boxedArray) {
        float[] result = new float[boxedArray.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = boxedArray[i] != null ? boxedArray[i].floatValue() : -3.4028235E38f;
        }
        return result;
    }

    public static int[] getUnboxedArray(Integer[] boxedArray) {
        int[] result = new int[boxedArray.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = boxedArray[i] != null ? boxedArray[i] : Integer.MIN_VALUE;
        }
        return result;
    }

    public static long[] getUnboxedArray(Long[] boxedArray) {
        long[] result = new long[boxedArray.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = boxedArray[i] != null ? boxedArray[i] : Long.MIN_VALUE;
        }
        return result;
    }

    public static short[] getUnboxedArray(Short[] boxedArray) {
        short[] result = new short[boxedArray.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = boxedArray[i] != null ? (int)boxedArray[i].shortValue() : Short.MIN_VALUE;
        }
        return result;
    }

    public static byte[] getUnboxedByteArray(Object[] boxedArray) {
        byte[] result = new byte[boxedArray.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = boxedArray[i] != null ? (int)((Number)boxedArray[i]).byteValue() : -128;
        }
        return result;
    }

    public static char[] getUnboxedCharArray(Object[] boxedArray) {
        char[] result = new char[boxedArray.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = boxedArray[i] != null ? (int)((Character)boxedArray[i]).charValue() : 65535;
        }
        return result;
    }

    public static short[] getUnboxedShortArray(Object[] boxedArray) {
        short[] result = new short[boxedArray.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = boxedArray[i] != null ? (int)((Number)boxedArray[i]).shortValue() : Short.MIN_VALUE;
        }
        return result;
    }

    public static int[] getUnboxedIntArray(Object[] boxedArray) {
        int[] result = new int[boxedArray.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = boxedArray[i] != null ? ((Number)boxedArray[i]).intValue() : Integer.MIN_VALUE;
        }
        return result;
    }

    public static long[] getUnboxedLongArray(Object[] boxedArray) {
        long[] result = new long[boxedArray.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = boxedArray[i] != null ? ((Number)boxedArray[i]).longValue() : Long.MIN_VALUE;
        }
        return result;
    }

    public static float[] getUnboxedFloatArray(Object[] boxedArray) {
        float[] result = new float[boxedArray.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = boxedArray[i] != null ? ((Number)boxedArray[i]).floatValue() : -3.4028235E38f;
        }
        return result;
    }

    public static double[] getUnboxedDoubleArray(Object[] boxedArray) {
        double[] result = new double[boxedArray.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = boxedArray[i] != null ? ((Number)boxedArray[i]).doubleValue() : -1.7976931348623157E308;
        }
        return result;
    }

    public static Object[] getBoxedArray(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> c = value.getClass();
        if (c.equals(boolean[].class)) {
            return ArrayTypeUtils.getBoxedArray((boolean[])value);
        }
        if (c.equals(byte[].class)) {
            return ArrayTypeUtils.getBoxedArray((byte[])value);
        }
        if (c.equals(char[].class)) {
            return ArrayTypeUtils.getBoxedArray((char[])value);
        }
        if (c.equals(double[].class)) {
            return ArrayTypeUtils.getBoxedArray((double[])value);
        }
        if (c.equals(float[].class)) {
            return ArrayTypeUtils.getBoxedArray((float[])value);
        }
        if (c.equals(int[].class)) {
            return ArrayTypeUtils.getBoxedArray((int[])value);
        }
        if (c.equals(long[].class)) {
            return ArrayTypeUtils.getBoxedArray((long[])value);
        }
        if (c.equals(short[].class)) {
            return ArrayTypeUtils.getBoxedArray((short[])value);
        }
        return (Object[])value;
    }

    public static boolean equals(Object actualValue, Object expectedValue) {
        Class<?> ct = actualValue.getClass().getComponentType();
        if (Object.class.isAssignableFrom(ct)) {
            return Arrays.equals((Object[])actualValue, (Object[])expectedValue);
        }
        if (Byte.TYPE.isAssignableFrom(ct)) {
            return Arrays.equals((byte[])actualValue, (byte[])expectedValue);
        }
        if (Character.TYPE.isAssignableFrom(ct)) {
            return Arrays.equals((char[])actualValue, (char[])expectedValue);
        }
        if (Double.TYPE.isAssignableFrom(ct)) {
            return Arrays.equals((double[])actualValue, (double[])expectedValue);
        }
        if (Float.TYPE.isAssignableFrom(ct)) {
            return Arrays.equals((float[])actualValue, (float[])expectedValue);
        }
        if (Integer.TYPE.isAssignableFrom(ct)) {
            return Arrays.equals((int[])actualValue, (int[])expectedValue);
        }
        if (Long.TYPE.isAssignableFrom(ct)) {
            return Arrays.equals((long[])actualValue, (long[])expectedValue);
        }
        if (Short.TYPE.isAssignableFrom(ct)) {
            return Arrays.equals((short[])actualValue, (short[])expectedValue);
        }
        return false;
    }

    public static String toString(Object actualValue) {
        Class<?> ct = actualValue.getClass().getComponentType();
        if (Object.class.isAssignableFrom(ct)) {
            return Arrays.toString((Object[])actualValue);
        }
        if (Byte.TYPE.isAssignableFrom(ct)) {
            return Arrays.toString((byte[])actualValue);
        }
        if (Character.TYPE.isAssignableFrom(ct)) {
            return Arrays.toString((char[])actualValue);
        }
        if (Double.TYPE.isAssignableFrom(ct)) {
            return Arrays.toString((double[])actualValue);
        }
        if (Float.TYPE.isAssignableFrom(ct)) {
            return Arrays.toString((float[])actualValue);
        }
        if (Integer.TYPE.isAssignableFrom(ct)) {
            return Arrays.toString((int[])actualValue);
        }
        if (Long.TYPE.isAssignableFrom(ct)) {
            return Arrays.toString((long[])actualValue);
        }
        if (Short.TYPE.isAssignableFrom(ct)) {
            return Arrays.toString((short[])actualValue);
        }
        return null;
    }

    public static String toString(boolean[] a, int offset, int length) {
        if (a == null) {
            return "(null)";
        }
        int iMax = offset + length - 1;
        if (iMax < 0) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = offset;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(byte[] a, int offset, int length) {
        if (a == null) {
            return "(null)";
        }
        int iMax = offset + length - 1;
        if (iMax < 0) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = offset;
        while (true) {
            b.append(a[i] == -128 ? "(null)" : Byte.valueOf(a[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(char[] a, int offset, int length) {
        if (a == null) {
            return "(null)";
        }
        int iMax = offset + length - 1;
        if (iMax < 0) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = offset;
        while (true) {
            b.append(a[i] == '\uffff' ? "(null)" : Character.valueOf(a[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(short[] a, int offset, int length) {
        if (a == null) {
            return "(null)";
        }
        int iMax = offset + length - 1;
        if (iMax < 0) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = offset;
        while (true) {
            b.append(a[i] == Short.MIN_VALUE ? "(null)" : Short.valueOf(a[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(int[] a, int offset, int length) {
        if (a == null) {
            return "(null)";
        }
        int iMax = offset + length - 1;
        if (iMax < 0) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = offset;
        while (true) {
            b.append(a[i] == Integer.MIN_VALUE ? "(null)" : Integer.valueOf(a[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(long[] a, int offset, int length) {
        if (a == null) {
            return "(null)";
        }
        int iMax = offset + length - 1;
        if (iMax < 0) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = offset;
        while (true) {
            b.append(a[i] == Long.MIN_VALUE ? "(null)" : Long.valueOf(a[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(float[] a, int offset, int length) {
        if (a == null) {
            return "(null)";
        }
        int iMax = offset + length - 1;
        if (iMax < 0) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = offset;
        while (true) {
            b.append(a[i] == -3.4028235E38f ? "(null)" : Float.valueOf(a[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(double[] a, int offset, int length) {
        if (a == null) {
            return "(null)";
        }
        int iMax = offset + length - 1;
        if (iMax < 0) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = offset;
        while (true) {
            b.append(a[i] == -1.7976931348623157E308 ? "(null)" : Double.valueOf(a[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(Object[] a, int offset, int length) {
        if (a == null) {
            return "(null)";
        }
        int iMax = offset + length - 1;
        if (iMax < 0) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = offset;
        while (true) {
            if (a[i] == null) {
                b.append("(null)");
            } else {
                b.append('\'').append(a[i]).append('\'');
            }
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static class ShortArrayAccessor
    implements ArrayAccessor<Short> {
        private short[] array;

        public ShortArrayAccessor(short[] array) {
            this.array = array;
        }

        @Override
        public void set(int index, Short value) {
            this.array[index] = value == null ? Short.MIN_VALUE : (int)value.shortValue();
        }

        @Override
        public Short get(int index) {
            return this.array[index];
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public Object getArray() {
            return this.array;
        }

        @Override
        public void fill(int from, int to, Short value) {
            if (value == null) {
                Arrays.fill(this.array, from, to, (short)Short.MIN_VALUE);
            } else {
                Arrays.fill(this.array, from, to, value);
            }
        }

        @Override
        public void copyArray(Object sourceArray, int pos, int length) {
            System.arraycopy(sourceArray, 0, this.array, pos, length);
        }
    }

    public static class LongArrayAccessor
    implements ArrayAccessor<Long> {
        private long[] array;

        public LongArrayAccessor(long[] array) {
            this.array = array;
        }

        @Override
        public void set(int index, Long value) {
            this.array[index] = value == null ? Long.MIN_VALUE : value;
        }

        @Override
        public Long get(int index) {
            return this.array[index];
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public Object getArray() {
            return this.array;
        }

        @Override
        public void fill(int from, int to, Long value) {
            if (value == null) {
                Arrays.fill(this.array, from, to, Long.MIN_VALUE);
            } else {
                Arrays.fill(this.array, from, to, value);
            }
        }

        @Override
        public void copyArray(Object sourceArray, int pos, int length) {
            System.arraycopy(sourceArray, 0, this.array, pos, length);
        }
    }

    public static class IntArrayAccessor
    implements ArrayAccessor<Integer> {
        private int[] array;

        public IntArrayAccessor(int[] array) {
            this.array = array;
        }

        @Override
        public void set(int index, Integer value) {
            this.array[index] = value == null ? Integer.MIN_VALUE : value;
        }

        @Override
        public Integer get(int index) {
            return this.array[index];
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public Object getArray() {
            return this.array;
        }

        @Override
        public void fill(int from, int to, Integer value) {
            if (value == null) {
                Arrays.fill(this.array, from, to, Integer.MIN_VALUE);
            } else {
                Arrays.fill(this.array, from, to, value);
            }
        }

        @Override
        public void copyArray(Object sourceArray, int pos, int length) {
            if (sourceArray == null) {
                throw new NullPointerException();
            }
            Require.requirement((boolean)(sourceArray instanceof int[]), (String)"sourceArray instanceof int[]", sourceArray.getClass(), (String)"sourceArray.getClass()");
            System.arraycopy(sourceArray, 0, this.array, pos, length);
        }
    }

    public static class FloatArrayAccessor
    implements ArrayAccessor<Float> {
        private float[] array;

        public FloatArrayAccessor(float[] array) {
            this.array = array;
        }

        @Override
        public void set(int index, Float value) {
            this.array[index] = value == null ? -3.4028235E38f : value.floatValue();
        }

        @Override
        public Float get(int index) {
            return Float.valueOf(this.array[index]);
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public Object getArray() {
            return this.array;
        }

        @Override
        public void fill(int from, int to, Float value) {
            if (value == null) {
                Arrays.fill(this.array, from, to, -3.4028235E38f);
            } else {
                Arrays.fill(this.array, from, to, value.floatValue());
            }
        }

        @Override
        public void copyArray(Object sourceArray, int pos, int length) {
            System.arraycopy(sourceArray, 0, this.array, pos, length);
        }
    }

    public static class DoubleArrayAccessor
    implements ArrayAccessor<Double> {
        private double[] array;

        public DoubleArrayAccessor(double[] array) {
            this.array = array;
        }

        @Override
        public void set(int index, Double value) {
            this.array[index] = value == null ? -1.7976931348623157E308 : value;
        }

        @Override
        public Double get(int index) {
            return this.array[index];
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public Object getArray() {
            return this.array;
        }

        @Override
        public void fill(int from, int to, Double value) {
            if (value == null) {
                Arrays.fill(this.array, from, to, -1.7976931348623157E308);
            } else {
                Arrays.fill(this.array, from, to, value);
            }
        }

        @Override
        public void copyArray(Object sourceArray, int pos, int length) {
            System.arraycopy(sourceArray, 0, this.array, pos, length);
        }
    }

    public static class CharArrayAccessor
    implements ArrayAccessor<Character> {
        private char[] array;

        public CharArrayAccessor(char[] array) {
            this.array = array;
        }

        @Override
        public void set(int index, Character value) {
            this.array[index] = value == null ? 65535 : (int)value.charValue();
        }

        @Override
        public Character get(int index) {
            return Character.valueOf(this.array[index]);
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public Object getArray() {
            return this.array;
        }

        @Override
        public void fill(int from, int to, Character value) {
            if (value == null) {
                Arrays.fill(this.array, from, to, '\uffff');
            } else {
                Arrays.fill(this.array, from, to, value.charValue());
            }
        }

        @Override
        public void copyArray(Object sourceArray, int pos, int length) {
            System.arraycopy(sourceArray, 0, this.array, pos, length);
        }
    }

    public static class ByteArrayAccessor
    implements ArrayAccessor<Byte> {
        private byte[] array;

        public ByteArrayAccessor(byte[] array) {
            this.array = array;
        }

        @Override
        public void set(int index, Byte value) {
            this.array[index] = value == null ? -128 : (int)value.byteValue();
        }

        @Override
        public Byte get(int index) {
            return this.array[index];
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public Object getArray() {
            return this.array;
        }

        @Override
        public void fill(int from, int to, Byte value) {
            if (value == null) {
                Arrays.fill(this.array, from, to, (byte)-128);
            } else {
                Arrays.fill(this.array, from, to, value);
            }
        }

        @Override
        public void copyArray(Object sourceArray, int pos, int length) {
            System.arraycopy(sourceArray, 0, this.array, pos, length);
        }
    }

    public static class BooleanArrayAccessor
    implements ArrayAccessor<Boolean> {
        private Boolean[] array;

        public BooleanArrayAccessor(Boolean[] array) {
            this.array = array;
        }

        @Override
        public void set(int index, Boolean value) {
            this.array[index] = value == null ? QueryConstants.NULL_BOOLEAN : value;
        }

        @Override
        public Boolean get(int index) {
            return this.array[index];
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public Object getArray() {
            return this.array;
        }

        @Override
        public void fill(int from, int to, Boolean value) {
            if (value == null) {
                Arrays.fill((Object[])this.array, from, to, QueryConstants.NULL_BOOLEAN);
            } else {
                Arrays.fill((Object[])this.array, from, to, value);
            }
        }

        @Override
        public void copyArray(Object sourceArray, int pos, int length) {
            System.arraycopy(sourceArray, 0, this.array, pos, length);
        }
    }

    public static class ObjectArrayAccessor<T>
    implements ArrayAccessor<T> {
        private T[] array;

        public ObjectArrayAccessor(T[] array) {
            this.array = array;
        }

        @Override
        public void set(int index, T value) {
            this.array[index] = value;
        }

        @Override
        public T get(int index) {
            return this.array[index];
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public Object getArray() {
            return this.array;
        }

        @Override
        public void fill(int from, int to, T value) {
            Arrays.fill(this.array, from, to, value);
        }

        @Override
        public void copyArray(Object sourceArray, int pos, int length) {
            if (sourceArray == null) {
                throw new NullPointerException();
            }
            System.arraycopy(sourceArray, 0, this.array, pos, length);
        }
    }

    public static interface ArrayAccessor<T> {
        public void set(int var1, T var2);

        public T get(int var1);

        public int length();

        public Object getArray();

        public void fill(int var1, int var2, T var3);

        public void copyArray(Object var1, int var2, int var3);
    }
}

