/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.type;

import org.jetbrains.annotations.NotNull;

public class ClassUtils {
    @NotNull
    public static <T> Class<? extends T> checkedClassForName(String className, Class<T> expectedType) {
        Class<?> resultClass;
        try {
            resultClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find class: " + className, e);
        }
        if (!expectedType.isAssignableFrom(resultClass)) {
            throw new RuntimeException("Invalid session class, " + resultClass.getCanonicalName() + ", does not implement " + expectedType.getCanonicalName());
        }
        return resultClass;
    }
}

