/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.appmode;

import io.deephaven.appmode.ApplicationConfigImpl;
import io.deephaven.appmode.DynamicApplication;
import io.deephaven.appmode.QSTApplication;
import io.deephaven.appmode.ScriptApplication;
import io.deephaven.appmode.StaticClassApplication;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public interface ApplicationConfig {
    public static boolean isCustomApplicationModeEnabled() {
        return ApplicationConfigImpl.applicationDir().isPresent();
    }

    public static Path customApplicationDir() {
        Optional<Path> applicationDir = ApplicationConfigImpl.applicationDir();
        if (applicationDir.isEmpty()) {
            throw new IllegalStateException(String.format("Custom application mode is not enabled, please set the configuration property '%s'", "deephaven.application.dir"));
        }
        return applicationDir.get();
    }

    public static List<ApplicationConfig> find() throws IOException, ClassNotFoundException {
        return ApplicationConfigImpl.find(ApplicationConfig.customApplicationDir());
    }

    public boolean isEnabled();

    public <V extends Visitor> V walk(V var1);

    public static interface Visitor {
        public void visit(ScriptApplication var1);

        public void visit(StaticClassApplication<?> var1);

        public void visit(QSTApplication var1);

        public void visit(DynamicApplication<?> var1);
    }
}

