/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.appmode;

import io.deephaven.appmode.ApplicationState;
import java.util.function.Consumer;

public class ApplicationContext {
    private static final ThreadLocal<ApplicationState> states = new ThreadLocal();

    public static ApplicationState get() {
        ApplicationState state = states.get();
        if (state == null) {
            throw new IllegalStateException("Should not be getting application state outside runUnderContext");
        }
        return state;
    }

    public static void initialize(Consumer<ApplicationState> initializer) {
        initializer.accept(ApplicationContext.get());
    }

    public static void runUnderContext(ApplicationState context, Runnable runner) {
        states.set(context);
        try {
            runner.run();
        }
        finally {
            states.remove();
        }
    }
}

