/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.appmode;

import io.deephaven.appmode.Field;
import io.deephaven.appmode.StandardField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;

public class ApplicationState {
    private final Listener listener;
    private final String id;
    private final String name;
    private final Map<String, Field<?>> fields;

    public ApplicationState(Listener listener, String id, String name) {
        this.listener = Objects.requireNonNull(listener);
        this.id = Objects.requireNonNull(id);
        this.name = Objects.requireNonNull(name);
        this.fields = new HashMap();
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public synchronized int numFieldsExported() {
        return this.fields.size();
    }

    public synchronized List<Field<?>> listFields() {
        return new ArrayList(this.fields.values());
    }

    public synchronized void clearFields() {
        this.fields.forEach((name, field) -> this.listener.onRemoveField(this, (Field<?>)field));
        this.fields.clear();
    }

    public synchronized <T> Field<T> getField(String name) {
        return this.fields.get(name);
    }

    public synchronized <T> void setField(String name, T value) {
        this.setField(StandardField.of(name, value));
    }

    public synchronized <T> void setField(String name, T value, String description) {
        this.setField(StandardField.of(name, value, description));
    }

    public synchronized void setField(Field<?> field) {
        Field<?> oldField = this.fields.remove(field.name());
        if (oldField != null) {
            this.listener.onRemoveField(this, field);
        }
        this.listener.onNewField(this, field);
        this.fields.put(field.name(), field);
    }

    public synchronized void setFields(Field<?> ... fields) {
        this.setFields(Arrays.asList(fields));
    }

    public synchronized void setFields(Iterable<Field<?>> fields) {
        for (Field<?> field : fields) {
            this.setField(field);
        }
    }

    public synchronized void removeField(String name) {
        Field<?> field = this.fields.remove(name);
        if (field != null) {
            this.listener.onRemoveField(this, field);
        }
    }

    public synchronized void removeFields(String ... names) {
        this.removeFields(Arrays.asList(names));
    }

    public synchronized void removeFields(Iterable<String> names) {
        for (String name : names) {
            this.removeField(name);
        }
    }

    public static interface Listener {
        public void onNewField(ApplicationState var1, Field<?> var2);

        public void onRemoveField(ApplicationState var1, Field<?> var2);
    }

    public static interface Factory {
        public static Iterable<Factory> loadFromServiceFactory() {
            return ServiceLoader.load(Factory.class);
        }

        public ApplicationState create(Listener var1);
    }
}

