/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.appmode;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public class ApplicationUtil {
    private static final String FILE_PROP_PREFIX = "file_";

    public static Path[] findFilesFrom(Properties properties) {
        return (Path[])properties.stringPropertyNames().stream().filter(ApplicationUtil::isFileProperty).map(prop -> ApplicationUtil.toOrderedFile(prop, Paths.get(properties.getProperty((String)prop), new String[0]))).sorted().map(of -> of.file).toArray(Path[]::new);
    }

    public static boolean isEnabled(Properties properties) {
        return Boolean.parseBoolean((String)properties.getOrDefault((Object)"enabled", "true"));
    }

    public static boolean isAsciiPrintable(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            char ch = cs.charAt(i);
            if (ch >= ' ' && ch < '\u007f') continue;
            return false;
        }
        return true;
    }

    private static boolean isFileProperty(String propName) {
        if (!propName.startsWith(FILE_PROP_PREFIX) || propName.length() == FILE_PROP_PREFIX.length()) {
            return false;
        }
        for (int i = FILE_PROP_PREFIX.length(); i < propName.length(); ++i) {
            char ch = propName.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    private static OrderedFile toOrderedFile(String propName, Path path) {
        String orderString = propName.substring(FILE_PROP_PREFIX.length());
        return new OrderedFile(Integer.parseInt(orderString), path);
    }

    private static class OrderedFile
    implements Comparable<OrderedFile> {
        int order;
        Path file;

        OrderedFile(int order, Path file) {
            this.file = file;
            this.order = order;
        }

        @Override
        public int compareTo(OrderedFile o) {
            return Integer.compare(this.order, o.order);
        }
    }
}

