/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.appmode;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.appmode.ApplicationConfig;
import io.deephaven.appmode.ApplicationState;
import io.deephaven.appmode.ApplicationUtil;
import io.deephaven.appmode.ImmutableDynamicApplication;
import java.util.Properties;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
public abstract class DynamicApplication<T extends ApplicationState.Factory>
implements ApplicationConfig {
    public static final String TYPE = "dynamic";

    public static DynamicApplication<ApplicationState.Factory> parse(Properties properties) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(properties.getProperty("class"));
        return ImmutableDynamicApplication.of(clazz, ApplicationUtil.isEnabled(properties));
    }

    public static <T extends ApplicationState.Factory> DynamicApplication<T> of(Class<T> clazz, boolean isEnabled) {
        return ImmutableDynamicApplication.of(clazz, isEnabled);
    }

    @Value.Parameter
    public abstract Class<T> clazz();

    @Override
    @Value.Parameter
    public abstract boolean isEnabled();

    public final ApplicationState create(ApplicationState.Listener appStateListener) throws InstantiationException, IllegalAccessException {
        return ((ApplicationState.Factory)this.clazz().newInstance()).create(appStateListener);
    }

    @Override
    public final <V extends ApplicationConfig.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Value.Check
    final void checkClazz() {
        if (!ApplicationState.Factory.class.isAssignableFrom(this.clazz())) {
            throw new IllegalArgumentException(String.format("clazz should extend '%s'", ApplicationState.Factory.class));
        }
    }
}

