/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.appmode;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.appmode.Field;
import io.deephaven.appmode.ImmutableFields;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class Fields
implements Iterable<Field<?>> {
    public static Builder builder() {
        return ImmutableFields.builder();
    }

    public static Fields of(Field<?> ... fields) {
        return Fields.builder().addFields(fields).build();
    }

    public static Fields of(Collection<Field<?>> fields) {
        return Fields.builder().addAllFields(fields).build();
    }

    abstract Map<String, Field<?>> fields();

    public final int size() {
        return this.fields().size();
    }

    @Override
    public final Iterator<Field<?>> iterator() {
        return this.fields().values().iterator();
    }

    @Override
    public final void forEach(Consumer<? super Field<?>> action) {
        this.fields().values().forEach(action);
    }

    @Override
    public final Spliterator<Field<?>> spliterator() {
        return this.fields().values().spliterator();
    }

    @Value.Check
    final void checkKeys() {
        for (Map.Entry<String, Field<?>> e : this.fields().entrySet()) {
            if (e.getKey().equals(e.getValue().name())) continue;
            throw new IllegalArgumentException("field name must be used as the key");
        }
    }

    public static interface Builder {
        public Builder putFields(String var1, Field<?> var2);

        default public Builder addFields(Field<?> field) {
            return this.putFields(field.name(), field);
        }

        default public Builder addFields(Field<?> ... fields) {
            for (Field<?> field : fields) {
                this.addFields(field);
            }
            return this;
        }

        default public Builder addAllFields(Collection<Field<?>> fields) {
            for (Field<?> field : fields) {
                this.addFields(field);
            }
            return this;
        }

        public Fields build();
    }
}

