/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.appmode;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.appmode.Application;
import io.deephaven.appmode.Fields;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Application", generator="Immutables")
@Immutable
final class ImmutableApplication
extends Application {
    private final String id;
    private final String name;
    private final Fields fields;

    private ImmutableApplication(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.fields = builder.fields;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Fields fields() {
        return this.fields;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableApplication && this.equalTo(0, (ImmutableApplication)another);
    }

    private boolean equalTo(int synthetic, ImmutableApplication another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.fields.equals(another.fields);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.fields.hashCode();
        return h;
    }

    public String toString() {
        return "Application{id=" + this.id + ", name=" + this.name + ", fields=" + this.fields + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Application", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements Application.Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_FIELDS = 4L;
        private long initBits = 7L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private Fields fields;

        private Builder() {
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            Builder.checkNotIsSet(this.idIsSet(), "id");
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            Builder.checkNotIsSet(this.nameIsSet(), "name");
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder fields(Fields fields) {
            Builder.checkNotIsSet(this.fieldsIsSet(), "fields");
            this.fields = Objects.requireNonNull(fields, "fields");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        public ImmutableApplication build() {
            this.checkRequiredAttributes();
            return new ImmutableApplication(this);
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean fieldsIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Application is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.fieldsIsSet()) {
                attributes.add("fields");
            }
            return "Cannot build Application, some of required attributes are not set " + attributes;
        }
    }
}

