/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.appmode;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.appmode.Field;
import io.deephaven.appmode.Fields;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Fields", generator="Immutables")
@Immutable
final class ImmutableFields
extends Fields {
    private final Map<String, Field<?>> fields;

    private ImmutableFields(Builder builder) {
        this.fields = ImmutableFields.createUnmodifiableMap(false, false, builder.fields);
    }

    @Override
    Map<String, Field<?>> fields() {
        return this.fields;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFields && this.equalTo(0, (ImmutableFields)another);
    }

    private boolean equalTo(int synthetic, ImmutableFields another) {
        return this.fields.equals(another.fields);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.fields.hashCode();
        return h;
    }

    public String toString() {
        return "Fields{fields=" + this.fields + "}";
    }

    private static ImmutableFields validate(ImmutableFields instance) {
        instance.checkKeys();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="Fields", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements Fields.Builder {
        private final Map<String, Field<?>> fields = new LinkedHashMap();

        private Builder() {
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putFields(String key, Field<?> value) {
            this.fields.put(Objects.requireNonNull(key, "fields key"), value == null ? Objects.requireNonNull(value, "fields value for key: " + key) : value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putFields(Map.Entry<String, ? extends Field<?>> entry) {
            Field<?> v;
            String k = entry.getKey();
            this.fields.put(Objects.requireNonNull(k, "fields key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "fields value for key: " + k) : v);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAllFields(Map<String, ? extends Field<?>> entries) {
            for (Map.Entry<String, Field<?>> e : entries.entrySet()) {
                Field<?> v;
                String k = e.getKey();
                this.fields.put(Objects.requireNonNull(k, "fields key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "fields value for key: " + k) : v);
            }
            return this;
        }

        @Override
        public ImmutableFields build() {
            return ImmutableFields.validate(new ImmutableFields(this));
        }
    }
}

