/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.appmode;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.appmode.ScriptApplication;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ScriptApplication", generator="Immutables")
@Immutable
final class ImmutableScriptApplication
extends ScriptApplication {
    private final String id;
    private final String name;
    private final List<Path> files;
    private final boolean isEnabled;
    private final String scriptType;

    private ImmutableScriptApplication(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.files = ImmutableScriptApplication.createUnmodifiableList(true, builder.files);
        this.scriptType = builder.scriptType;
        this.isEnabled = builder.isEnabledIsSet() ? builder.isEnabled : super.isEnabled();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<Path> files() {
        return this.files;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public String scriptType() {
        return this.scriptType;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScriptApplication && this.equalTo(0, (ImmutableScriptApplication)another);
    }

    private boolean equalTo(int synthetic, ImmutableScriptApplication another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.files.equals(another.files) && this.isEnabled == another.isEnabled && this.scriptType.equals(another.scriptType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.files.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isEnabled);
        h += (h << 5) + this.scriptType.hashCode();
        return h;
    }

    public String toString() {
        return "ScriptApplication{id=" + this.id + ", name=" + this.name + ", files=" + this.files + ", isEnabled=" + this.isEnabled + ", scriptType=" + this.scriptType + "}";
    }

    private static ImmutableScriptApplication validate(ImmutableScriptApplication instance) {
        instance.checkNotEmpty();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ScriptApplication", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements ScriptApplication.Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_SCRIPT_TYPE = 4L;
        private static final long OPT_BIT_IS_ENABLED = 1L;
        private long initBits = 7L;
        private long optBits;
        @Nullable
        private String id;
        @Nullable
        private String name;
        private final List<Path> files = new ArrayList<Path>();
        private boolean isEnabled;
        @Nullable
        private String scriptType;

        private Builder() {
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            Builder.checkNotIsSet(this.idIsSet(), "id");
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            Builder.checkNotIsSet(this.nameIsSet(), "name");
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addFiles(Path element) {
            this.files.add(Objects.requireNonNull(element, "files element"));
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addFiles(Path ... elements) {
            for (Path element : elements) {
                this.files.add(Objects.requireNonNull(element, "files element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllFiles(Iterable<? extends Path> elements) {
            for (Path path : elements) {
                this.files.add(Objects.requireNonNull(path, "files element"));
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder isEnabled(boolean isEnabled) {
            Builder.checkNotIsSet(this.isEnabledIsSet(), "isEnabled");
            this.isEnabled = isEnabled;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder scriptType(String scriptType) {
            Builder.checkNotIsSet(this.scriptTypeIsSet(), "scriptType");
            this.scriptType = Objects.requireNonNull(scriptType, "scriptType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        public ImmutableScriptApplication build() {
            this.checkRequiredAttributes();
            return ImmutableScriptApplication.validate(new ImmutableScriptApplication(this));
        }

        private boolean isEnabledIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean scriptTypeIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ScriptApplication is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.scriptTypeIsSet()) {
                attributes.add("scriptType");
            }
            return "Cannot build ScriptApplication, some of required attributes are not set " + attributes;
        }
    }
}

