/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.appmode;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.appmode.StandardField;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StandardField", generator="Immutables")
@Immutable
final class ImmutableStandardField<T>
extends StandardField<T> {
    private final String name;
    private final T value;
    @Nullable
    private final String description;

    private ImmutableStandardField(Builder<T> builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.description = builder.description;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public T value() {
        return this.value;
    }

    @Override
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStandardField && this.equalTo(0, (ImmutableStandardField)another);
    }

    private boolean equalTo(int synthetic, ImmutableStandardField<?> another) {
        return this.name.equals(another.name) && this.value.equals(another.value) && Objects.equals(this.description, another.description);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("StandardField{");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("value=").append(this.value);
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        return builder.append("}").toString();
    }

    private static <T> ImmutableStandardField<T> validate(ImmutableStandardField<T> instance) {
        instance.checkDescription();
        instance.checkName();
        return instance;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="StandardField", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private static final long OPT_BIT_DESCRIPTION = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String name;
        @Nullable
        private T value;
        @Nullable
        private String description;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> name(String name) {
            Builder.checkNotIsSet(this.nameIsSet(), "name");
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> value(T value) {
            Builder.checkNotIsSet(this.valueIsSet(), "value");
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> description(String description) {
            Builder.checkNotIsSet(this.descriptionIsSet(), "description");
            this.description = Objects.requireNonNull(description, "description");
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> description(Optional<String> description) {
            Builder.checkNotIsSet(this.descriptionIsSet(), "description");
            this.description = description.orElse(null);
            this.optBits |= 1L;
            return this;
        }

        public ImmutableStandardField<T> build() {
            this.checkRequiredAttributes();
            return ImmutableStandardField.validate(new ImmutableStandardField(this));
        }

        private boolean descriptionIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean valueIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of StandardField is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.valueIsSet()) {
                attributes.add("value");
            }
            return "Cannot build StandardField, some of required attributes are not set " + attributes;
        }
    }
}

