/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.appmode;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.appmode.ApplicationConfig;
import io.deephaven.appmode.ApplicationUtil;
import io.deephaven.appmode.ImmutableScriptApplication;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class ScriptApplication
implements ApplicationConfig {
    public static final String TYPE = "script";

    public static Builder builder() {
        return ImmutableScriptApplication.builder();
    }

    public static ScriptApplication parse(Properties properties) {
        return ScriptApplication.builder().isEnabled(ApplicationUtil.isEnabled(properties)).id(properties.getProperty("id")).name(properties.getProperty("name")).scriptType(properties.getProperty("scriptType").toLowerCase()).addFiles(ApplicationUtil.findFilesFrom(properties)).build();
    }

    public abstract String id();

    public abstract String name();

    public abstract List<Path> files();

    @Override
    @Value.Default
    public boolean isEnabled() {
        return true;
    }

    public abstract String scriptType();

    @Override
    public final <V extends ApplicationConfig.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Value.Check
    final void checkNotEmpty() {
        if (this.files().isEmpty()) {
            throw new IllegalArgumentException("Must specify at least one file to execute");
        }
    }

    public static interface Builder {
        public Builder isEnabled(boolean var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder addFiles(Path var1);

        public Builder addFiles(Path ... var1);

        public Builder scriptType(String var1);

        public ScriptApplication build();
    }
}

