/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.appmode;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.appmode.ApplicationUtil;
import io.deephaven.appmode.Field;
import io.deephaven.appmode.ImmutableStandardField;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class StandardField<T>
implements Field<T> {
    public static <T> Field<T> of(String name, T value) {
        return ImmutableStandardField.builder().name(name).value(value).build();
    }

    public static <T> Field<T> of(String name, T value, String description) {
        return ImmutableStandardField.builder().name(name).value(value).description(description).build();
    }

    @Override
    public abstract String name();

    @Override
    public abstract T value();

    @Override
    public abstract Optional<String> description();

    @Value.Check
    final void checkName() {
        if (!ApplicationUtil.isAsciiPrintable(this.name())) {
            throw new IllegalArgumentException("name() is invalid, must be printable ascii");
        }
    }

    @Value.Check
    final void checkDescription() {
        if (this.description().isPresent() && this.description().get().isEmpty()) {
            throw new IllegalArgumentException("description(), when present, must not be empty");
        }
    }
}

