/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.appmode;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.appmode.Application;
import io.deephaven.appmode.ApplicationConfig;
import io.deephaven.appmode.ApplicationUtil;
import io.deephaven.appmode.ImmutableStaticClassApplication;
import java.util.Properties;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
public abstract class StaticClassApplication<T extends Application.Factory>
implements ApplicationConfig {
    public static final String TYPE = "static";

    public static StaticClassApplication<Application.Factory> parse(Properties properties) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(properties.getProperty("class"));
        return ImmutableStaticClassApplication.of(clazz, ApplicationUtil.isEnabled(properties));
    }

    public static <T extends Application.Factory> StaticClassApplication<T> of(Class<T> clazz, boolean isEnabled) {
        return ImmutableStaticClassApplication.of(clazz, isEnabled);
    }

    @Value.Parameter
    public abstract Class<T> clazz();

    @Override
    @Value.Parameter
    public abstract boolean isEnabled();

    public final Application create() throws InstantiationException, IllegalAccessException {
        return ((Application.Factory)this.clazz().newInstance()).create();
    }

    @Override
    public final <V extends ApplicationConfig.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Value.Check
    final void checkClazz() {
        if (!Application.Factory.class.isAssignableFrom(this.clazz())) {
            throw new IllegalArgumentException(String.format("clazz should extend '%s'", Application.Factory.class));
        }
    }
}

