/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.auth;

import io.deephaven.auth.AuthContext;
import io.deephaven.auth.AuthenticationRequestHandler;
import io.deephaven.configuration.Configuration;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import java.nio.ByteBuffer;
import java.util.Optional;

public class AnonymousAuthenticationHandler
implements AuthenticationRequestHandler {
    private static final boolean WARN_ANONYMOUS_ACCESS = Configuration.getInstance().getBoolean("authentication.anonymous.warn");
    private static final Logger log = LoggerFactory.getLogger(AnonymousAuthenticationHandler.class);

    @Override
    public String getAuthType() {
        return "Anonymous";
    }

    @Override
    public void initialize(String targetUrl) {
        if (WARN_ANONYMOUS_ACCESS) {
            log.warn().nl().nl().nl().nl().endl();
            log.warn().append((CharSequence)"================================================================================").endl();
            log.warn().append((CharSequence)"WARNING! Anonymous authentication is enabled. This is not recommended!").endl();
            log.warn().append((CharSequence)"       Listening on ").append((CharSequence)targetUrl).endl();
            log.warn().append((CharSequence)"================================================================================").endl();
            log.warn().nl().nl().nl().nl().endl();
        } else {
            log.info().append((CharSequence)"Anonymous authentication is enabled. Listening on ").append((CharSequence)targetUrl).endl();
        }
    }

    @Override
    public Optional<AuthContext> login(long protocolVersion, ByteBuffer payload, AuthenticationRequestHandler.HandshakeResponseListener listener) {
        if (!payload.hasRemaining()) {
            return Optional.of(new AuthContext.Anonymous());
        }
        return Optional.empty();
    }

    @Override
    public Optional<AuthContext> login(String payload, AuthenticationRequestHandler.MetadataResponseListener listener) {
        if (payload.isEmpty()) {
            return Optional.of(new AuthContext.Anonymous());
        }
        return Optional.empty();
    }
}

